/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.syntona.gui.patch.ModuleEditor;
import com.syntona.gui.patch.ModuleView;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.jsyn.FloatSampleModule;
import com.syntona.model.jsyn.SequentialDataView;
import com.syntona.plugin.Jack;
import com.syntona.plugin.ModulePresenter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FloatSampleModulePresenter
extends ModulePresenter {
    private FloatSampleModule sampleModule;

    public FloatSampleModulePresenter() {
        super(new FloatSampleModule());
        this.setView(new SequentialDataView(this));
        this.sampleModule = (FloatSampleModule)this.getModule();
    }

    @Override
    public ModuleEditor createModuleEditor() {
        return new SampleFileSelectionEditor(this.getView());
    }

    public String getSuffix() {
        return ".wav";
    }

    @Override
    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException, SAXException, IOException {
        String path;
        Element sampleElement = XMLDOMLoader.getChildByTagName(moduleElement, "sample");
        if (sampleElement != null && (path = sampleElement.getAttribute("file")) != null) {
            String title = "Missing sample WAV file!";
            File referenceFile = loader.getLoadFile();
            File fileToLoad = this.findFileToLoad(path, referenceFile, title, this.getSuffix());
            if (fileToLoad != null) {
                this.sampleModule.loadFromSampleFile(fileToLoad);
            }
        }
        super.loadContents(loader, moduleElement);
    }

    private class SampleFileSelectionEditor
    extends ModuleEditor {
        JLabel mLabel;
        JButton mSaveButton;

        public SampleFileSelectionEditor(ModuleView moduleView) {
            super(moduleView);
        }

        public void updateSampleLabel() {
            String name = FloatSampleModulePresenter.this.sampleModule.getSampleFile() == null ? "----" : FloatSampleModulePresenter.this.sampleModule.getSampleFile().getName();
            this.mLabel.setText(name);
        }

        @Override
        public Component setupJackEditors(ModuleView moduleView, Jack[] jacks) {
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 3));
            this.mLabel = new JLabel();
            this.updateSampleLabel();
            topPanel.add(this.mLabel);
            JPanel panel = new JPanel();
            JButton loadButton = new JButton("Load...");
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File defaultFile = FloatSampleModulePresenter.this.sampleModule.getSampleFile() == null ? new File(".") : FloatSampleModulePresenter.this.sampleModule.getSampleFile();
                    File file = SyntonaEngine.getInstance().getGUIService().askOpenFile(defaultFile, FloatSampleModulePresenter.this.getSuffix());
                    if (file != null) {
                        try {
                            FloatSampleModulePresenter.this.sampleModule.loadFromSampleFile(file);
                            SampleFileSelectionEditor.this.updateSampleLabel();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    FloatSampleModulePresenter.this.hideMainEditor();
                }
            });
            panel.add(loadButton);
            this.mSaveButton = new JButton("Save");
            this.mSaveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FloatSampleModulePresenter.this.sampleModule.saveToSampleFile();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    FloatSampleModulePresenter.this.hideMainEditor();
                }
            });
            this.mSaveButton.setEnabled(false);
            panel.add(this.mSaveButton);
            JButton saveAsButton = new JButton("Save As...");
            saveAsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File defaultFile = FloatSampleModulePresenter.this.sampleModule.getSampleFile() == null ? new File("Untitled.wav") : FloatSampleModulePresenter.this.sampleModule.getSampleFile();
                    File file = SyntonaEngine.getInstance().getGUIService().askSaveFile(defaultFile, FloatSampleModulePresenter.this.getSuffix());
                    if (file != null) {
                        try {
                            FloatSampleModulePresenter.this.sampleModule.saveToSampleFile(file);
                            SampleFileSelectionEditor.this.updateSampleLabel();
                            SampleFileSelectionEditor.this.mSaveButton.setEnabled(true);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                    FloatSampleModulePresenter.this.hideMainEditor();
                }
            });
            panel.add(saveAsButton);
            topPanel.add(panel);
            return topPanel;
        }
    }
}

