/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.ComponentPartner;
import com.syntona.gui.patch.JackInABox;
import com.syntona.gui.patch.JackPartner;
import com.syntona.gui.patch.ModulePartner;
import com.syntona.gui.patch.ModulePickerTree;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.gui.patch.RubberBander;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.Bundle;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.SyntonaModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class PatchBox
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final int DRAG_IDLE = 0;
    private static final int DRAG_RECT = 1;
    private static final int DRAG_LINE = 2;
    private static final int DRAG_SELECT = 3;
    private static final int DRAG_ADJUST = 4;
    public static final Color COLOR_MODULE_SELECTED = Color.RED;
    public static final Color COLOR_CONNECTION_NORMAL = Color.BLACK;
    public static final Color COLOR_CONNECTION_SELECTED = Color.ORANGE;
    private CopyOnWriteArrayList<ModuleView> moduleViews = new CopyOnWriteArrayList();
    private PatchModulePresenter patchModulePresenter;
    private RubberBander rubberBand;
    private int startX;
    private int startY;
    private int offsetX;
    private int offsetY;
    private Jack targetJack = null;
    private Jack sourceJack = null;
    private int dragState = 0;
    private Rectangle draggingRect = null;
    private Rectangle tempPanelRect = null;
    private PatchFrame patchFrame;
    private boolean debug = false;
    private ConnectionPicker connectionPicker;
    private Logger logger = Logger.getLogger(PatchBox.class.getName());
    static final int MODE_RUN = 0;
    static final int MODE_CUT = 1;
    static final int MODE_EDIT = 2;
    private int mode = 1;
    private static int nextIndex = 0;
    private int index;
    private boolean alive = true;
    private Object mLastPickedSource;
    private Object mLastPickedDestination;
    private InputDoubleJack mAdjustingJack;
    private JackInABox mAdjustingComponent;
    private int lastY;
    private static final Color COLOR_BACKGROUND = new Color(250, 245, 240);

    public PatchBox(PatchModulePresenter patchModulePresenter, PatchFrame patchFrame) {
        this.patchModulePresenter = patchModulePresenter;
        this.patchFrame = patchFrame;
        this.index = nextIndex++;
        this.setLayout(null);
        this.setBackground(COLOR_BACKGROUND);
        this.rubberBand = new RubberBander();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocusInWindow();
        Component glassPane = patchFrame.getRootPane().getGlassPane();
        glassPane.addKeyListener(this);
        this.setTransferHandler(new ToTreeTransferHandler());
    }

    String getTagName() {
        return "patchModule";
    }

    void startDragSelecting(MouseEvent e) {
        if (!e.isShiftDown()) {
            this.deselectAll();
        }
        this.startX = e.getX();
        this.startY = e.getY();
        this.rubberBand.startRectangle(this.startX, this.startY, 1, 1);
        this.dragState = 3;
    }

    void deselectAll() {
        for (ModuleView moduleView : this.moduleViews) {
            moduleView.setSelected(false);
        }
    }

    public ModulePresenter[] getSelectedModulePresenters() {
        ArrayList<ModulePresenter> selectedModules = new ArrayList<ModulePresenter>();
        for (ModuleView moduleView : this.moduleViews) {
            if (!moduleView.isSelected()) continue;
            selectedModules.add(moduleView.getPresenter());
        }
        return selectedModules.toArray(new ModulePresenter[0]);
    }

    Rectangle getSelectedBounds() {
        Iterator<ModuleView> modules = this.moduleViews.iterator();
        Rectangle rect = null;
        this.debug("getSelectedBounds: ==============================");
        while (modules.hasNext()) {
            ModuleView modulePanel = modules.next();
            this.debug("getSelectedBounds: modulePanel = " + modulePanel.getModule().getName());
            if (!modulePanel.isSelected()) continue;
            this.debug("getSelectedBounds: selected!");
            if (rect == null) {
                rect = modulePanel.getBounds();
                continue;
            }
            Rectangle modRect = modulePanel.getBounds();
            rect = rect.union(modRect);
        }
        this.debug("getSelectedBounds: ---------------------------------");
        return rect;
    }

    Rectangle getGroupBounds() {
        Iterator<ModuleView> modules = this.moduleViews.iterator();
        Rectangle rect = null;
        while (modules.hasNext()) {
            ModuleView modulePanel = modules.next();
            if (rect == null) {
                rect = modulePanel.getBounds();
                continue;
            }
            Rectangle modRect = modulePanel.getBounds();
            rect = rect.union(modRect);
        }
        return rect;
    }

    private boolean selectBoundedModules(Rectangle rect) {
        boolean changed = false;
        for (ModuleView modulePanel : this.moduleViews) {
            boolean touched = rect.intersects(modulePanel.getBounds());
            if (touched == modulePanel.isSelected()) continue;
            modulePanel.setSelected(touched);
            changed = true;
        }
        return changed;
    }

    void startDragging(MouseEvent e) {
        this.debug("startDragging");
        Component comp = e.getComponent();
        JComponent jcomp = (JComponent)comp;
        ComponentPartner partner = ComponentPartner.getComponentPartner(jcomp);
        int selectionOffsetX = 0;
        int selectionOffsetY = 0;
        if (partner != null) {
            if (partner instanceof ModulePartner) {
                ModulePartner modulePartner = (ModulePartner)partner;
                if (e.isShiftDown()) {
                    if (modulePartner.isSelected()) {
                        modulePartner.setSelected(false);
                        return;
                    }
                    modulePartner.setSelected(true);
                } else if (!modulePartner.isSelected()) {
                    this.deselectAll();
                    modulePartner.setSelected(true);
                }
            }
            this.tempPanelRect = this.getBounds();
            this.draggingRect = this.getSelectedBounds();
            if (this.draggingRect == null) {
                this.debug("startDragging: nothing selected");
                return;
            }
            this.offsetX = e.getX() - this.draggingRect.x - selectionOffsetX;
            this.offsetY = e.getY() - this.draggingRect.y - selectionOffsetY;
            Graphics g = this.getGraphics();
            if (g != null) {
                this.rubberBand.startMovingRectangle(g, this.draggingRect.x, this.draggingRect.y, this.draggingRect.width, this.draggingRect.height);
                this.dragState = 1;
            }
        }
    }

    private void startConnecting(JackPartner jackPartner, Point trackingPoint) {
        Point refLoc = this.getLocationOnScreen();
        this.startX = trackingPoint.x - refLoc.x;
        this.startY = trackingPoint.y - refLoc.y;
        this.sourceJack = jackPartner.getJack();
        Point tie = jackPartner.getTiePoint(refLoc);
        this.rubberBand.startLine(tie.x, tie.y);
        this.dragState = 2;
    }

    private void startAdjustingValue(InputDoubleJack jack, JackInABox comp, int x, int y) {
        this.startX = x;
        this.startY = y;
        this.lastY = y;
        this.mAdjustingJack = jack;
        this.mAdjustingComponent = comp;
        this.dragState = 4;
        comp.incrementForceValueDisplay();
        comp.updateText();
    }

    private void setJackByXY(int x, int y) {
        int xdiff = this.startX - x;
        double SENSITIVITY1 = 0.01;
        double SENSITIVITY2 = 0.01;
        double power = (double)xdiff * 0.01;
        double perPixel = 0.01 * Math.pow(2.0, power);
        int ydiff = this.lastY - y;
        this.lastY = y;
        double fractionalDelta = (double)ydiff * perPixel;
        double jackRange = this.mAdjustingJack.getMax() - this.mAdjustingJack.getMin();
        double valueDelta = fractionalDelta * jackRange;
        this.mAdjustingJack.clipAndSetValue(this.mAdjustingJack.getValue() + valueDelta);
    }

    private void continueAdjusting(int x, int y) {
        this.setJackByXY(x, y);
        this.mAdjustingComponent.updateText();
    }

    private void finishAdjusting() {
        this.mAdjustingComponent.decrementForceValueDisplay();
        this.mAdjustingComponent.updateText();
        this.mAdjustingJack = null;
        this.mAdjustingComponent = null;
        this.dragState = 0;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        switch (this.dragState) {
            case 1: {
                this.continueDragging(e.getX(), e.getY());
                break;
            }
            case 2: {
                this.rubberBand.undrawLine(this.getGraphics());
                this.rubberBand.drawLine(this.getGraphics(), this.startX + e.getX(), this.startY + e.getY());
                break;
            }
            case 3: {
                this.rubberBand.dragRectangle(this.getGraphics(), e.getX(), e.getY());
                this.selectModulesByRectangle(e);
                break;
            }
            case 4: {
                this.continueAdjusting(e.getX(), e.getY());
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.rubberBand.markErased();
    }

    boolean selectModulesByRectangle(MouseEvent e) {
        int height;
        int width;
        Rectangle rect;
        boolean changed;
        int temp;
        int x1 = this.startX;
        int x2 = e.getX();
        int y1 = this.startY;
        int y2 = e.getY();
        if (x2 < x1) {
            temp = x2;
            x2 = x1;
            x1 = temp;
        }
        if (y2 < y1) {
            temp = y2;
            y2 = y1;
            y1 = temp;
        }
        if (changed = this.selectBoundedModules(rect = new Rectangle(x1, y1, width = x2 - x1, height = y2 - y1))) {
            this.repaint();
        }
        return changed;
    }

    private void updatePanelSize() {
        ModuleView[] all;
        int maxX = 50;
        int maxY = 50;
        ModuleView[] moduleViewArray = all = this.moduleViews.toArray(new ModuleView[0]);
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleView modulePanel = moduleViewArray[n2];
            Point modLoc = modulePanel.getLocation();
            int farX = modLoc.x + modulePanel.getWidth();
            int farY = modLoc.y + modulePanel.getHeight();
            if (farX > maxX) {
                maxX = farX;
            }
            if (farY > maxY) {
                maxY = farY;
            }
            ++n2;
        }
        this.setMinimumSize(new Dimension(maxX += 11, maxY += 12));
        this.setPreferredSize(new Dimension(maxX, maxY));
    }

    void shiftSelectedModules(int deltaX, int deltaY) {
        Iterator<ModuleView> modules = this.moduleViews.iterator();
        for (ModuleView moduleView : this.moduleViews) {
            if (!moduleView.isSelected()) continue;
            Point modLoc = moduleView.getLocation();
            moduleView.setXY(modLoc.x + deltaX, modLoc.y + deltaY);
        }
    }

    int clipDraggedX(int mouseX) {
        int x = mouseX - this.offsetX;
        if (x < 0) {
            x = 0;
        } else if (x + this.draggingRect.width > this.tempPanelRect.width) {
            x = this.tempPanelRect.width - this.draggingRect.width;
        }
        return x;
    }

    int clipDraggedY(int mouseY) {
        int y = mouseY - this.offsetY;
        if (y < 0) {
            y = 0;
        } else if (y + this.draggingRect.height > this.tempPanelRect.height) {
            y = this.tempPanelRect.height - this.draggingRect.height;
        }
        return y;
    }

    void continueDragging(int xpos, int ypos) {
        if (this.draggingRect != null) {
            int x = this.clipDraggedX(xpos);
            int y = this.clipDraggedY(ypos);
            this.rubberBand.moveRectangle(this.getGraphics(), x, y);
        }
    }

    void finishDragging(int xpos, int ypos) {
        this.rubberBand.endRectangle(this.getGraphics());
        if (this.draggingRect != null) {
            int x = this.clipDraggedX(xpos);
            int y = this.clipDraggedY(ypos);
            int deltaX = x - this.draggingRect.x;
            int deltaY = y - this.draggingRect.y;
            if (deltaX != 0 || deltaY != 0) {
                this.shiftSelectedModules(deltaX, deltaY);
                this.updatePanelSize();
                this.patchModulePresenter.markDirty();
                this.repaint();
            }
            this.draggingRect = null;
        }
    }

    void finishConnecting() {
        this.rubberBand.endLine(this.getGraphics());
        this.debug("finishConnecting: targetJack = " + this.targetJack);
        if (this.targetJack != null) {
            SyntonaEngine.getInstance().sendConnectJacks(this.sourceJack, this.targetJack);
            this.restoreCursor();
            this.patchModulePresenter.markDirty();
            this.repaint();
        }
        this.targetJack = null;
        this.sourceJack = null;
    }

    private void restoreCursor() {
        this.patchFrame.setCursor(Cursor.getDefaultCursor());
    }

    private void setCursorCanConnect() {
        this.patchFrame.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void setCursorCanPick() {
        this.patchFrame.setCursor(Cursor.getPredefinedCursor(1));
    }

    private void setCursorCanMove() {
        this.patchFrame.setCursor(Cursor.getPredefinedCursor(13));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ConnectionPicker picker;
        if (e.getComponent() == this && this.patchFrame.getPatchEditor() == this.patchFrame.getTopPatchEditor().getFrontPatchEditor() && (picker = this.connectionPicker) != null) {
            Point location;
            boolean pickChanged;
            boolean hit = picker.pickConnection(e);
            boolean bl = pickChanged = this.mLastPickedSource != picker.getPickedSource() || this.mLastPickedDestination != picker.getPickedDestination();
            if ((!hit || pickChanged) && this.mLastPickedSource != null && this.mLastPickedDestination != null) {
                this.mLastPickedSource = null;
                this.mLastPickedDestination = null;
                this.restoreCursor();
                picker.g = this.getGraphics();
                location = this.getLocationOnScreen();
                picker.redrawLastConnection(location);
            }
            if (hit && pickChanged) {
                this.mLastPickedSource = picker.getPickedSource();
                this.mLastPickedDestination = picker.getPickedDestination();
                this.setCursorCanPick();
                picker.g = this.getGraphics();
                location = this.getLocationOnScreen();
                picker.drawPickedConnection(location);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void edit(ModulePresenter modulePresenter) {
        modulePresenter.showMainEditor();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.alive) {
            throw new RuntimeException("PatchBox #" + this.index + ": mousePressed on dead patchbox!");
        }
        this.sourceJack = null;
        Component comp = e.getComponent();
        comp.requestFocusInWindow();
        if (comp == this) {
            ConnectionPicker picker = this.connectionPicker;
            boolean hit = picker.pickConnection(e);
            if (hit) {
                if (this.mode == 1) {
                    SyntonaEngine.getInstance().sendDisconnectJacks((Jack)picker.getPickedSource(), (Jack)picker.getPickedDestination());
                    this.patchModulePresenter.markDirty();
                }
                this.repaint();
            } else {
                this.debug("startDragSelecting");
                this.startDragSelecting(e);
                this.repaint();
            }
        } else if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            ComponentPartner partner = ComponentPartner.getComponentPartner(jcomp);
            boolean handled = false;
            if (partner != null) {
                if (partner instanceof JackPartner) {
                    JackPartner jackPartner = (JackPartner)partner;
                    Jack jack = jackPartner.getJack();
                    if (jackPartner.isOutput()) {
                        this.startConnecting(jackPartner, comp.getLocationOnScreen());
                        handled = true;
                    } else if (jack instanceof InputJack && !(jack instanceof InputActionJack)) {
                        int num = jack.getConnectedCount();
                        if (num > 0) {
                            Jack other = jack.getConnected(num - 1);
                            jack.disconnect(other);
                            this.repaint();
                            JackPartner otherPartner = other.getPartner();
                            this.targetJack = jack;
                            this.startConnecting(otherPartner, comp.getLocationOnScreen());
                            this.setCursorCanConnect();
                            handled = true;
                        } else if (jack instanceof InputDoubleJack) {
                            this.startAdjustingValue((InputDoubleJack)jack, (JackInABox)jcomp, e.getX(), e.getY());
                            handled = true;
                        }
                    }
                }
                if (!handled && partner instanceof ModulePartner) {
                    this.startDragging(e);
                }
            }
        }
    }

    private void debug(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        switch (this.dragState) {
            case 1: {
                this.finishDragging(e.getX(), e.getY());
                break;
            }
            case 2: {
                this.finishConnecting();
                break;
            }
            case 3: {
                this.rubberBand.undrawRectangle(this.getGraphics());
                this.selectModulesByRectangle(e);
                this.repaint();
                break;
            }
            case 4: {
                this.finishAdjusting();
            }
        }
        this.dragState = 0;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.debug("PatchBox #" + this.index + ", showing = " + this.isShowing() + ": mouseEntered e = " + e);
        Component comp = e.getComponent();
        JackPartner jackPartner = JackPartner.getJackPartner(comp);
        if (jackPartner != null) {
            Jack overJack = jackPartner.getJack();
            if (this.sourceJack == null) {
                if (overJack.isOutput()) {
                    this.setCursorCanConnect();
                } else {
                    this.setCursorCanMove();
                }
            } else if (comp != this && this.sourceJack.willAccept(overJack) && overJack.willAccept(this.sourceJack)) {
                this.debug("mouseEntered: set targetJack = " + overJack);
                this.targetJack = overJack;
                this.setCursorCanConnect();
                this.rubberBand.setBandColor(Color.CYAN);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.restoreCursor();
        this.rubberBand.setBandColor(RubberBander.getDefaultBandColor());
        this.debug("mouseExited: set targetJack = null");
        this.targetJack = null;
    }

    public void addModule(ModuleView moduleView) {
        this.moduleViews.add(moduleView);
        this.add((Component)moduleView, 0);
        this.updatePanelSize();
        this.refreshDisplay();
    }

    public void removeModule(ModuleView moduleView) {
        this.moduleViews.remove(moduleView);
        this.remove(moduleView);
        this.updatePanelSize();
        this.refreshDisplay();
    }

    void refreshDisplay() {
        this.validate();
        this.repaint();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.moduleViews.clear();
    }

    void drawConnections(ConnectionPicker g, SyntonaModule module, Point refLoc) {
        Jack[] jacks = module.getJacks();
        int i = 0;
        Jack[] jackArray = jacks;
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            try {
                double offset = (1.0 + (double)i++) / (double)(1 + jacks.length);
                this.drawConnections(g, refLoc, jack, offset);
            }
            catch (IllegalComponentStateException e) {
                System.out.println("Bad Jack! Caught " + e);
            }
            ++n2;
        }
    }

    private void drawBentConnection(ConnectionPicker g, int x1, int y1, int x2, int y2, double offset) {
        boolean newKick = false;
        int MIN_DX = 10;
        g.fillRect(x1, y1 - 4, 4, 8);
        g.fillRect(x2 - 4, y2 - 4, 4, 8);
        if (x1 + 20 < x2) {
            if (y1 == y2) {
                g.drawLine(x1, y1, x2, y2);
            } else {
                int xmid = (x1 + x2) / 2;
                double offsetScaled = y2 < y1 ? offset - 0.5 : 0.5 - offset;
                int xKick = xmid + (int)((double)(x2 - x1) * offsetScaled);
                g.drawLine(x1, y1, xKick, y1);
                g.drawLine(xKick, y1, xKick, y2);
                g.drawLine(xKick, y2, x2, y2);
            }
        } else {
            int ymid = (y1 + y2) / 2;
            double yOffsetScaled = y2 < y1 ? offset - 0.5 : 0.5 - offset;
            int yKick = ymid + (int)(20.0 * yOffsetScaled);
            double xOffsetScaled = y2 < y1 ? offset : 1.0 - offset;
            int xKick = (int)(50.0 * xOffsetScaled);
            g.drawLine(x1, y1, x1 + xKick, y1);
            g.drawLine(x1 + xKick, y1, x1 + xKick, yKick);
            g.drawLine(x1 + xKick, yKick, x2 - xKick, yKick);
            g.drawLine(x2 - xKick, yKick, x2 - xKick, y2);
            g.drawLine(x2 - xKick, y2, x2, y2);
        }
    }

    private void drawConnections(ConnectionPicker connectionPicker, Point refLoc, Jack jack, double offset) {
        if (jack != null && jack instanceof OutputJack && jack.getPartner() != null) {
            Iterator<Jack> connected = jack.getConnected();
            while (connected.hasNext()) {
                Jack otherJack = connected.next();
                JackPartner otherPartner = otherJack.getPartner();
                if (otherPartner == null) {
                    this.logger.warning("otherJack has null partner, " + otherJack);
                    continue;
                }
                boolean isSelected = jack.getPartner().isSelected();
                Color conColorNotSelected = jack.getSignalColor();
                connectionPicker.setDrawnSource(jack);
                connectionPicker.setDrawnDestination(otherJack);
                if (isSelected || otherPartner.isSelected()) {
                    connectionPicker.setColor(COLOR_MODULE_SELECTED);
                } else {
                    connectionPicker.setColor(conColorNotSelected);
                }
                Point inPoint = otherPartner.getTiePoint(refLoc);
                Point outPoint = jack.getPartner().getTiePoint(refLoc);
                this.drawBentConnection(connectionPicker, outPoint.x, outPoint.y, inPoint.x, inPoint.y, offset);
            }
        }
    }

    public void drawPatchConnections(Graphics g, Point refLoc) {
        ConnectionPicker tempPicker = new ConnectionPicker(g);
        tempPicker.setReferencePoint(refLoc);
        for (ModuleView moduleView : this.moduleViews) {
            if (moduleView.isSelected()) continue;
            this.drawConnections(tempPicker, moduleView.getModule(), refLoc);
        }
        for (ModuleView moduleView : this.moduleViews) {
            if (!moduleView.isSelected()) continue;
            this.drawConnections(tempPicker, moduleView.getModule(), refLoc);
        }
        this.connectionPicker = tempPicker;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    class ConnectionPicker {
        private Graphics g;
        private ArrayList<LineTracker> lineTrackers = new ArrayList();
        private Object drawnSource;
        private Object drawnDestination;
        private Point mRefLoc;
        private Object pickedSource;
        private Object pickedDestination;

        public Object getPickedDestination() {
            return this.pickedDestination;
        }

        public Object getPickedSource() {
            return this.pickedSource;
        }

        ConnectionPicker(Graphics g) {
            this.g = g;
        }

        public boolean pickConnection(int x1, int y1, int x2, int y2) {
            this.pickedSource = null;
            this.pickedDestination = null;
            boolean hit = false;
            int w = x2 - x1;
            int h = y2 - y1;
            for (LineTracker tracker : this.lineTrackers) {
                if (!tracker.line.intersects(x1, y1, w, h)) continue;
                this.pickedSource = tracker.source;
                this.pickedDestination = tracker.destination;
                hit = true;
                break;
            }
            return hit;
        }

        public boolean pickConnection(MouseEvent e) {
            Point boxLoc = e.getComponent().getLocationOnScreen();
            Point refLoc = this.getReferencePoint();
            int dx = refLoc.x - boxLoc.x;
            int dy = refLoc.y - boxLoc.y;
            int x = e.getX() - dx;
            int y = e.getY() - dy;
            return this.pickConnection(x - 2, y - 2, x + 2, y + 2);
        }

        public void drawPickedConnection(Point location) {
            int xOffset = location.x - this.mRefLoc.x;
            int yOffset = location.y - this.mRefLoc.y;
            Color lastColor = this.g.getColor();
            this.g.setColor(COLOR_CONNECTION_SELECTED);
            for (LineTracker tracker : this.lineTrackers) {
                if (this.pickedSource != tracker.source || this.pickedDestination != tracker.destination) continue;
                this.drawTracker(tracker, xOffset, yOffset);
            }
            this.drawnSource = this.pickedSource;
            this.drawnDestination = this.pickedDestination;
            this.g.setColor(lastColor);
        }

        public void redrawLastConnection(Point location) {
            int xOffset = location.x - this.mRefLoc.x;
            int yOffset = location.y - this.mRefLoc.y;
            Color lastColor = this.g.getColor();
            for (LineTracker tracker : this.lineTrackers) {
                if (this.drawnSource != tracker.source || this.drawnDestination != tracker.destination) continue;
                this.g.setColor(tracker.color);
                this.drawTracker(tracker, xOffset, yOffset);
            }
            this.g.setColor(lastColor);
        }

        private void drawTracker(LineTracker tracker, int xOffset, int yOffset) {
            int x1 = (int)tracker.line.getX1() - xOffset;
            int x2 = (int)tracker.line.getX2() - xOffset;
            int y1 = (int)tracker.line.getY1() - yOffset;
            int y2 = (int)tracker.line.getY2() - yOffset;
            this.g.drawLine(x1, y1, x2, y2);
        }

        public void drawLine(int x1, int y1, int x2, int y2) {
            this.g.drawLine(x1, y1, x2, y2);
            Line2D.Double line2d = new Line2D.Double(x1, y1, x2, y2);
            LineTracker tracker = new LineTracker();
            tracker.color = this.g.getColor();
            tracker.line = line2d;
            tracker.source = this.drawnSource;
            tracker.destination = this.drawnDestination;
            this.lineTrackers.add(tracker);
        }

        public void fillRect(int x1, int y1, int x2, int y2) {
            this.g.fillRect(x1, y1, x2, y2);
        }

        public void setColor(Color c) {
            this.g.setColor(c);
        }

        public void setDrawnSource(Object object) {
            this.drawnSource = object;
        }

        public void setDrawnDestination(Object object) {
            this.drawnDestination = object;
        }

        public void setReferencePoint(Point refLoc) {
            this.mRefLoc = refLoc;
        }

        public Point getReferencePoint() {
            return this.mRefLoc;
        }
    }

    static class LineTracker {
        Line2D line;
        Object source;
        Object destination;
        public Color color;

        LineTracker() {
        }
    }

    class ToTreeTransferHandler
    extends TransferHandler {
        ToTreeTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            String data;
            if (!info.isDrop()) {
                return false;
            }
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return ModulePickerTree.isValidDrop(data);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            String data;
            if (!this.canImport(info)) {
                return false;
            }
            Transferable t = info.getTransferable();
            try {
                data = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            String[] values = data.split(",");
            String bundleName = values[1];
            String moduleType = values[2];
            TransferHandler.DropLocation loc = info.getDropLocation();
            Point point = loc.getDropPoint();
            Bundle bundle = SyntonaEngine.getInstance().getBundle(bundleName);
            SyntonaEngine.getInstance().sendAddModule(bundle, PatchBox.this.patchModulePresenter, moduleType, point.x, point.y);
            return true;
        }
    }
}

