/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.LabelledCanvas;
import com.syntona.plugin.Jack;
import java.awt.Color;
import java.awt.Graphics;

public class JackInABox
extends LabelledCanvas {
    private Jack jack;
    private boolean on;
    private Color ON_COLOR = new Color(255, 64, 0);
    private int mForceValueDisplay;

    public JackInABox(Jack jack) {
        super(jack.getDefaultText());
        this.jack = jack;
    }

    @Override
    public void drawUnderText(Graphics g) {
        if (this.on) {
            int width = this.getBounds().width;
            int height = this.getBounds().height;
            g.setColor(this.ON_COLOR);
            int x = (width - height) / 2;
            int y = 0;
            g.fillOval(x, y, height, height);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.jack.isOutput()) {
            this.drawOutputMarker(g);
        }
    }

    private void drawOutputMarker(Graphics g) {
        int width = this.getBounds().width;
        int[] px = new int[]{width - 6, width - 1, width - 1};
        int[] py = new int[]{1, 1, 6};
        g.setColor(this.getForeground());
        g.fillPolygon(px, py, 3);
    }

    public void setOn(boolean onOrOff) {
        this.on = onOrOff;
        this.repaint();
    }

    public void showValue() {
        this.setText(this.jack.getValueText());
    }

    public void showDefaultText() {
        this.setText(this.jack.getDefaultText());
    }

    public void updateText() {
        if (this.mForceValueDisplay > 0) {
            this.showValue();
        } else {
            this.showDefaultText();
        }
    }

    public void incrementForceValueDisplay() {
        ++this.mForceValueDisplay;
    }

    public void decrementForceValueDisplay() {
        --this.mForceValueDisplay;
    }
}

