/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import com.softsynth.util.Logger;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TextOutput
extends Frame {
    private static final long serialVersionUID = 1L;
    public int maxChars = 8192;
    int numChars = 0;
    static TextOutput staticTextOutput;
    static Logger logger;
    boolean isTextAreaEnabled = true;
    boolean isSystemOutEnabled = true;
    TextArea textArea;
    Button buttonClear;
    String lineTerminator = System.getProperty("line.separator", "\n");

    public TextOutput() {
        super("Text Output");
        this.setSize(620, 400);
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea("", 30, 120, 0);
        this.textArea.setEditable(false);
        this.textArea.setFont(Font.getFont("Monospaced-18"));
        this.add("Center", this.textArea);
        this.buttonClear = new Button("Clear");
        this.add("South", this.buttonClear);
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextOutput.this.textArea.setText("");
                TextOutput.this.numChars = 0;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TextOutput.this.hide();
            }
        });
    }

    public void setTextAreaEnable(boolean enabled) {
        this.isTextAreaEnabled = enabled;
    }

    public void setSystemOutEnable(boolean enabled) {
        this.isSystemOutEnabled = enabled;
    }

    private void append(String text) {
        int len = text.length();
        if (this.numChars + len > this.maxChars) {
            int numKill = this.maxChars / 4;
            this.textArea.replaceRange("", 0, numKill);
            this.numChars -= numKill;
        }
        this.textArea.append(text);
        this.numChars += len;
    }

    public void log(String msg) {
        if (this.isSystemOutEnabled) {
            System.out.print(msg);
        }
        if (this.isTextAreaEnabled) {
            this.append(msg);
        }
    }

    public void logln(String msg) {
        this.log(msg);
        this.logln();
    }

    public void logln() {
        if (this.isSystemOutEnabled) {
            System.out.println();
        }
        if (this.isTextAreaEnabled) {
            this.append(this.lineTerminator);
        }
    }

    public static void setLogger(Logger lgr) {
        logger = lgr;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void print(String msg) {
        if (staticTextOutput != null) {
            staticTextOutput.log(msg);
        } else {
            System.out.print(msg);
        }
        if (logger != null) {
            logger.log(msg);
        }
    }

    public static void println(String msg) {
        if (staticTextOutput != null) {
            staticTextOutput.logln(msg);
        } else {
            System.out.println(msg);
        }
        if (logger != null) {
            logger.logln(msg);
        }
    }

    public static void println() {
        if (staticTextOutput != null) {
            staticTextOutput.logln();
        } else {
            System.out.println();
        }
        if (logger != null) {
            logger.logln();
        }
    }

    public static void error(String msg) {
        TextOutput.println("ERROR: " + msg);
        throw new RuntimeException(msg);
    }

    public static void setStaticLocation(int x, int y) {
        TextOutput.getStaticInstance().setLocation(x, y);
    }

    public static TextOutput getStaticInstance() {
        if (staticTextOutput == null) {
            staticTextOutput = new TextOutput();
            staticTextOutput.setLocation(30, 0);
        }
        return staticTextOutput;
    }

    public static void open() {
        TextOutput.getStaticInstance().setVisible(true);
    }

    public static void close() {
        if (staticTextOutput != null) {
            staticTextOutput.setVisible(false);
        }
    }

    public static void bringToFront() {
        if (staticTextOutput != null) {
            staticTextOutput.toFront();
        }
    }
}

