/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.compose.swing;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.NoiseHit;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.instruments.WaveShapingVoice;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.VoiceAllocator;
import com.jsyn.util.WaveRecorder;
import com.softsynth.compose.swing.BasicScoreInstrument;
import com.softsynth.score.JSynScoreClock;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreInstrument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ComposerSynth {
    private Synthesizer synth = JSyn.createSynthesizer();
    private LineOut lineOut;
    private JSynScoreClock clock;
    private WaveRecorder recorder;
    private PassThrough passLeft;
    private PassThrough passRight;
    private WaveShapingVoice[] leadVoices;
    private SubtractiveSynthVoice[] rhythmVoices;
    private BasicScoreInstrument leadInstrument;
    private BasicScoreInstrument rhythmInstrument;
    private BasicScoreInstrument drumInstrument;
    private static boolean useRecorder = false;

    public ComposerSynth() {
        if (useRecorder) {
            File waveFile = new File("score_20130611.wav");
            try {
                this.recorder = new WaveRecorder(this.synth, waveFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                useRecorder = false;
            }
            System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
        }
        this.clock = new JSynScoreClock(this.synth);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.passLeft = new PassThrough();
        this.synth.add(this.passLeft);
        this.passRight = new PassThrough();
        this.synth.add(this.passRight);
        this.leadInstrument = this.createLeadInstrument(2);
        this.rhythmInstrument = this.createRhythmInstrument(8);
        this.drumInstrument = this.createDrumInstrument(2);
        this.passLeft.output.connect(0, this.lineOut.input, 0);
        this.passRight.output.connect(0, this.lineOut.input, 1);
        this.synth.start();
        this.lineOut.start();
    }

    public void start() {
        if (useRecorder) {
            this.passLeft.output.connect(0, this.recorder.getInput(), 0);
            this.passRight.output.connect(0, this.recorder.getInput(), 1);
            this.recorder.start();
        }
    }

    public void stop() {
        if (this.recorder != null) {
            this.recorder.stop();
            try {
                this.recorder.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private BasicScoreInstrument createRhythmInstrument(int numVoices) {
        this.rhythmVoices = new SubtractiveSynthVoice[numVoices];
        int i = 0;
        while (i < numVoices) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(this.passLeft.input);
            voice.getOutput().connect(this.passRight.input);
            this.rhythmVoices[i] = voice;
            ++i;
        }
        VoiceAllocator allocator = new VoiceAllocator(this.rhythmVoices);
        BasicScoreInstrument instrument = new BasicScoreInstrument(this.clock, allocator);
        return instrument;
    }

    private BasicScoreInstrument createLeadInstrument(int numVoices) {
        this.leadVoices = new WaveShapingVoice[numVoices];
        int i = 0;
        while (i < numVoices) {
            WaveShapingVoice voice = new WaveShapingVoice();
            this.synth.add(voice);
            voice.getOutput().connect(this.passLeft.input);
            voice.getOutput().connect(this.passRight.input);
            voice.usePreset(0);
            this.leadVoices[i] = voice;
            ++i;
        }
        VoiceAllocator allocator = new VoiceAllocator(this.leadVoices);
        BasicScoreInstrument instrument = new BasicScoreInstrument(this.clock, allocator);
        return instrument;
    }

    private BasicScoreInstrument createDrumInstrument(int numVoices) {
        UnitVoice[] voices = new NoiseHit[numVoices];
        int i = 0;
        while (i < numVoices) {
            NoiseHit voice = new NoiseHit();
            this.synth.add(voice);
            voice.getOutput().connect(this.passLeft.input);
            voice.getOutput().connect(this.passRight.input);
            voices[i] = voice;
            ++i;
        }
        VoiceAllocator allocator = new VoiceAllocator(voices);
        BasicScoreInstrument instrument = new BasicScoreInstrument(this.clock, allocator);
        return instrument;
    }

    public void setBrightness(double brightness) {
        Circuit voice;
        Circuit[] circuitArray = this.rhythmVoices;
        int n = this.rhythmVoices.length;
        int n2 = 0;
        while (n2 < n) {
            voice = circuitArray[n2];
            voice.cutoff.set(brightness * 1000.0 + 500.0);
            ++n2;
        }
        circuitArray = this.leadVoices;
        n = this.leadVoices.length;
        n2 = 0;
        while (n2 < n) {
            voice = circuitArray[n2];
            ((WaveShapingVoice)voice).range.set(0.8 * brightness + 0.2);
            ++n2;
        }
    }

    public ScoreInstrument getLeadInstrument() {
        return this.leadInstrument;
    }

    public ScoreInstrument getDrumInstrument() {
        return this.drumInstrument;
    }

    public ScoreInstrument getRhythmInstrument() {
        return this.rhythmInstrument;
    }

    public ScoreClock getClock() {
        return this.clock;
    }
}

