/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitFilter;

public class SchmidtTrigger
extends UnitFilter {
    public UnitInputPort setLevel = new UnitInputPort("SetLevel");
    public UnitInputPort resetLevel;
    public UnitOutputPort outputPulse;

    public SchmidtTrigger() {
        this.addPort(this.setLevel);
        this.resetLevel = new UnitInputPort("ResetLevel");
        this.addPort(this.resetLevel);
        this.outputPulse = new UnitOutputPort("OutputPulse");
        this.addPort(this.outputPulse);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inPtr = this.input.getValues();
        double[] pulsePtr = this.outputPulse.getValues();
        double[] outPtr = this.output.getValues();
        double[] setPtr = this.setLevel.getValues();
        double[] resetPtr = this.resetLevel.getValues();
        double outputValue = outPtr[0];
        boolean state = outputValue > 0.0;
        int i = start;
        while (i < limit) {
            pulsePtr[i] = 0.0;
            if (state) {
                if (inPtr[i] <= resetPtr[i]) {
                    state = false;
                    outputValue = 0.0;
                }
            } else if (inPtr[i] > setPtr[i]) {
                state = true;
                outputValue = 1.0;
                pulsePtr[i] = 1.0;
            }
            outPtr[i] = outputValue;
            ++i;
        }
    }
}

