/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.examples.GoogleWaveOscillator;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.LineOut;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SeeGoogleWave
extends JApplet {
    private Synthesizer synth;
    private GoogleWaveOscillator googleWaveUnit;
    private LineOut lineOut;
    private AudioScope scope;

    public static void main(String[] args) {
        SeeGoogleWave applet = new SeeGoogleWave();
        JAppletFrame frame = new JAppletFrame("Google Wave", applet);
        frame.setSize(640, 500);
        frame.setVisible(true);
        frame.test();
        frame.validate();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add("North", new JLabel("GoogleWave - elliptical segments"));
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.googleWaveUnit.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setShowControls(false);
        this.scope.start();
        this.add("Center", this.scope.getView());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(0, 1));
        this.add("South", southPanel);
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.googleWaveUnit.frequency));
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.googleWaveUnit.variance));
        southPanel.add(PortControllerFactory.createExponentialPortSlider(this.googleWaveUnit.amplitude));
        this.validate();
    }

    @Override
    public void start() {
        this.synth = JSyn.createSynthesizer();
        this.googleWaveUnit = new GoogleWaveOscillator();
        this.synth.add(this.googleWaveUnit);
        this.googleWaveUnit.amplitude.setup(0.02, 0.5, 1.0);
        this.googleWaveUnit.variance.setup(0.0, 0.0, 1.0);
        this.googleWaveUnit.frequency.setup(40.0, 200.0, 1000.0);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.googleWaveUnit.output.connect(0, this.lineOut.input, 0);
        this.googleWaveUnit.output.connect(0, this.lineOut.input, 1);
        this.setupGUI();
        this.synth.start();
        this.lineOut.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }
}

