/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.DualOscillatorSynthVoice;
import com.jsyn.midi.MidiSynthesizer;
import com.jsyn.util.AudioStreamReader;
import com.jsyn.util.MultiChannelSynthesizer;
import com.jsyn.util.VoiceDescription;
import com.jsyn.util.WaveFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class RenderMidiNotes {
    private static final int NUM_MIDI_CHANNELS = 16;
    private static final int VOICES_PER_MIDI_CHANNEL = 6;
    private Synthesizer mSynth;
    private int mNumChannels = 2;
    private MidiSynthesizer mMidiSynthesizer;
    private MultiChannelSynthesizer mMultiSynth;
    private AudioStreamReader mReader;
    private double[] mBuffer = new double[256 * this.mNumChannels];
    private ArrayList<Double> mSampleArray = new ArrayList();

    private void test() throws IOException, InterruptedException {
        this.mSynth = JSyn.createSynthesizer();
        this.mSynth.setRealTime(false);
        VoiceDescription voiceDescription = DualOscillatorSynthVoice.getVoiceDescription();
        this.mMultiSynth = new MultiChannelSynthesizer();
        boolean startChannel = false;
        this.mMultiSynth.setup(this.mSynth, 0, 16, 6, voiceDescription);
        this.mMidiSynthesizer = new MidiSynthesizer(this.mMultiSynth);
        this.mReader = new AudioStreamReader(this.mSynth, this.mNumChannels);
        this.mMultiSynth.getOutput().connect(0, this.mReader.getInput(), 0);
        this.mMultiSynth.getOutput().connect(0, this.mReader.getInput(), 1);
        this.mSynth.start(48000);
        double now = this.mSynth.getCurrentTime();
        int i = 0;
        while (i < 8) {
            byte[] bar = new byte[]{-112, (byte)(60 + 2 * i), 100};
            this.sendMidiMessage(bar);
            this.renderUntil(now += 0.2);
            bar[2] = 0;
            this.sendMidiMessage(bar);
            this.renderUntil(now += 0.2);
            ++i;
        }
        this.renderUntil(now += 0.3);
        double[] data = this.mSampleArray.stream().mapToDouble(d -> d).toArray();
        this.writeWavFile(data);
        this.mSynth.stop();
        System.out.println("Test finished.");
    }

    private void renderUntil(double time) throws InterruptedException {
        while (this.mSynth.getCurrentTime() < time) {
            this.mSynth.sleepFor(0.001);
            int available = this.mReader.available();
            while (available > 0) {
                int numSamplesToRead = Math.min(this.mBuffer.length, available);
                int numRead = this.mReader.read(this.mBuffer, 0, numSamplesToRead);
                int i = 0;
                while (i < numRead) {
                    this.mSampleArray.add(this.mBuffer[i]);
                    ++i;
                }
                available -= numRead;
            }
        }
    }

    private void sendMidiMessage(byte[] bytes) {
        this.mMidiSynthesizer.onReceive(bytes, 0, bytes.length);
    }

    private void writeWavFile(double[] data) throws FileNotFoundException, IOException {
        File outFile = new File("test.wav");
        WaveFileWriter writer = new WaveFileWriter(outFile);
        writer.setFrameRate(this.mSynth.getFrameRate());
        writer.setSamplesPerFrame(this.mNumChannels);
        writer.write(data);
        writer.close();
        System.out.println("wrote " + outFile.getAbsolutePath());
    }

    public static void main(String[] args) {
        try {
            new RenderMidiNotes().test();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

