/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.data;

import com.jsyn.data.SpectralWindow;

public class HammingWindow
implements SpectralWindow {
    private double[] data;

    public HammingWindow(int length, double alpha, double beta) {
        this.data = new double[length];
        double scaler = Math.PI * 2 / (double)(length - 1);
        int i = 0;
        while (i < length) {
            this.data[i] = alpha - beta * Math.cos((double)i * scaler);
            ++i;
        }
    }

    public HammingWindow(int length) {
        this(length, 0.5434782608695652, 0.45652173913043476);
    }

    @Override
    public double get(int index) {
        return this.data[index];
    }
}

