/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.tools;

import com.syntona.plugin.WireTime;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class ScheduledQueue {
    private SortedMap<WireTime, List<Object>> timeNodes = new TreeMap<WireTime, List<Object>>();

    public boolean isEmpty() {
        return this.timeNodes.isEmpty();
    }

    public synchronized void add(WireTime time, Object obj) {
        LinkedList<Object> timeList = (LinkedList<Object>)this.timeNodes.get(time);
        if (timeList == null) {
            timeList = new LinkedList<Object>();
            this.timeNodes.put(time, timeList);
        }
        timeList.add(obj);
    }

    public synchronized Object removeNext(WireTime time) {
        List timeList;
        WireTime lowestTime;
        Object next = null;
        if (!this.timeNodes.isEmpty() && (lowestTime = this.timeNodes.firstKey()).compareTo(time) <= 0 && (timeList = (List)this.timeNodes.get(lowestTime)) != null) {
            next = timeList.remove(0);
            if (timeList.isEmpty()) {
                this.timeNodes.remove(lowestTime);
            }
        }
        return next;
    }

    public WireTime getNextTime() {
        return this.timeNodes.firstKey();
    }
}

