/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.jsyn.util.TransportModel;
import com.syntona.model.SyntonaCommand;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.music.BeatTimer;
import com.syntona.plugin.DoubleRangeModel;
import com.syntona.plugin.WireTime;
import java.util.concurrent.CopyOnWriteArrayList;

public class BeatClock
extends TransportModel {
    public static final int PPQ = 1680;
    private static BeatClock instance;
    private boolean running;
    private DoubleRangeModel beatsPerMinute = new DoubleRangeModel(120.0, 10.0, 1000.0);
    private double referenceTime;
    private long referencePPQ;
    private CopyOnWriteArrayList<BeatTimer> timers = new CopyOnWriteArrayList();

    private BeatClock() {
        this.beatsPerMinute = new DoubleRangeModel(120.0, 10.0, 1000.0){

            @Override
            public void setValue(double value) {
                BeatClock.this.updateReference(BeatClock.this.getCurrentTime());
                super.setValue(value);
            }
        };
    }

    public static synchronized BeatClock getInstance() {
        if (instance == null) {
            instance = new BeatClock();
        }
        return instance;
    }

    public void rewind() {
        this.referencePPQ = 0L;
        for (BeatTimer timer : this.timers) {
            timer.rewind();
        }
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.referenceTime = this.getCurrentTime();
            for (BeatTimer timer : this.timers) {
                this.scheduleNextTick(timer);
            }
        }
    }

    public void pause() {
        this.updateReference(this.getCurrentTime());
        this.running = false;
    }

    public synchronized void setTempo(double tempo) {
        this.beatsPerMinute.setValue(tempo);
    }

    public double getTempo() {
        return this.beatsPerMinute.getValue();
    }

    public DoubleRangeModel getTempoModel() {
        return this.beatsPerMinute;
    }

    private void updateReference(double time) {
        if (this.running) {
            long offsetPPQ = (long)((time - this.referenceTime) * (1680.0 * this.beatsPerMinute.getValue()) / 60.0);
            this.referencePPQ += offsetPPQ;
            this.referenceTime = time;
        }
    }

    private double getEngineTime() {
        return SyntonaEngine.getInstance().getEngineTime().getTime();
    }

    private double getCurrentTime() {
        return SyntonaEngine.getInstance().getCurrentTime().getTime();
    }

    public double calculateNextTime(BeatTimer beatTimer) {
        long nextPPQ = beatTimer.getNextPPQ() - this.referencePPQ;
        double offset = (double)nextPPQ * 60.0 / (1680.0 * this.beatsPerMinute.getValue());
        return this.referenceTime + offset;
    }

    private void scheduleNextTick(BeatTimer beatTimer) {
        double nextTime = this.calculateNextTime(beatTimer);
        WireTime future = new WireTime(nextTime);
        BeatClockCommand cmd = new BeatClockCommand(beatTimer);
        SyntonaEngine.getInstance().send(future, cmd);
    }

    public void scheduleTimer(BeatTimer beatTimer) {
        this.updateReference(this.getCurrentTime());
        beatTimer.updateCounter(this.referencePPQ);
        this.timers.add(beatTimer);
        if (this.running) {
            this.scheduleNextTick(beatTimer);
        }
    }

    class BeatClockCommand
    implements SyntonaCommand {
        private BeatTimer beatTimer;

        public BeatClockCommand(BeatTimer beatTimer) {
            this.beatTimer = beatTimer;
        }

        @Override
        public void execute() {
            if (BeatClock.this.running) {
                this.beatTimer.run();
                BeatClock.this.scheduleNextTick(this.beatTimer);
            }
        }

        @Override
        public void undo() {
        }
    }
}

