/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.ModuleView;
import com.syntona.model.core.KeyMatchModule;
import com.syntona.plugin.ModulePresenter;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;

public class KeyMatchModuleView
extends ModuleView {
    private static final int HEIGHT = 46;
    private static final int WIDTH = 46;
    private KeyMatchModule keyMatchModule;
    private JButton keyButton;

    public KeyMatchModuleView() {
        this.setSize(46, 46);
    }

    public KeyMatchModuleView(ModulePresenter presenter) {
        super(presenter);
        this.setSize(46, 46);
        this.keyMatchModule = (KeyMatchModule)this.getModule();
    }

    @Override
    public void makeJacks() {
        this.setSize(46, 46);
        this.makeVerticalJackBoxes();
        this.keyButton = new JButton("" + this.keyMatchModule.getKey());
        this.keyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                KeyMatchModuleView.this.keyMatchModule.sendOnMessage();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                KeyMatchModuleView.this.keyMatchModule.sendOffMessage();
            }
        });
        Insets insets = this.getInsets();
        int height = 36 - insets.top - insets.bottom;
        this.keyButton.setSize(30, height);
        this.keyButton.setLocation(insets.left, insets.top + 10);
        this.addComponent(this.keyButton);
    }

    @Override
    public JComponent makeHeader() {
        HeaderBox header = this.createTopHeaderBox(this.getWidth());
        this.addComponent(header);
        return header;
    }

    public void setKey(char key) {
        this.keyButton.setText("" + key);
    }
}

