/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import java.awt.Color;
import java.awt.Graphics;

public class RubberBander {
    int lastX;
    int lastY;
    int lastWidth;
    int lastHeight;
    int startX;
    int startY;
    Color bandColor = RubberBander.getDefaultBandColor();
    Color drawnColor = RubberBander.getDefaultBandColor();
    private boolean drawn;

    public Color getBandColor() {
        return this.bandColor;
    }

    public static Color getDefaultBandColor() {
        return Color.WHITE;
    }

    public void setBandColor(Color bandColor) {
        this.bandColor = bandColor;
    }

    public void startLine(int x, int y) {
        this.lastX = this.startX = x;
        this.lastY = this.startY = y;
    }

    public void undrawLine(Graphics g) {
        g.setXORMode(this.drawnColor);
        g.drawLine(this.startX, this.startY, this.lastX, this.lastY);
        g.setPaintMode();
        this.drawn = false;
    }

    public void drawLine(Graphics g, int x, int y) {
        g.setXORMode(this.bandColor);
        this.drawnColor = this.bandColor;
        g.drawLine(this.startX, this.startY, x, y);
        g.setPaintMode();
        this.lastX = x;
        this.lastY = y;
        this.drawn = true;
    }

    public void endLine(Graphics g) {
        this.undrawLine(g);
    }

    public void startRectangle(int x, int y, int width, int height) {
        this.lastX = this.startX = x;
        this.lastY = this.startY = y;
        this.lastWidth = width;
        this.lastHeight = height;
    }

    void drawRectangle(Graphics g, int x, int y, int width, int height) {
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        g.drawRect(x, y, width, height);
    }

    public void dragRectangle(Graphics g, int x, int y) {
        if (this.drawn) {
            this.undrawRectangle(g);
        }
        this.drawRectangle(g, x, y);
    }

    public void drawRectangle(Graphics g, int x, int y) {
        this.lastWidth = x - this.startX;
        this.lastHeight = y - this.startY;
        g.setXORMode(this.bandColor);
        this.drawnColor = this.bandColor;
        this.drawRectangle(g, this.startX, this.startY, this.lastWidth, this.lastHeight);
        g.setPaintMode();
        this.drawn = true;
    }

    public void undrawRectangle(Graphics g) {
        g.setXORMode(this.drawnColor);
        this.drawRectangle(g, this.startX, this.startY, this.lastWidth, this.lastHeight);
        this.drawn = false;
    }

    public void startMovingRectangle(Graphics g, int x, int y, int width, int height) {
        this.lastX = x;
        this.lastY = y;
        this.lastWidth = width;
        this.lastHeight = height;
        g.drawRect(x, y, width, height);
        this.drawn = true;
    }

    public void moveRectangle(Graphics g, int x, int y) {
        g.setXORMode(this.bandColor);
        if (this.drawn) {
            g.drawRect(this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        }
        g.drawRect(x, y, this.lastWidth, this.lastHeight);
        g.setPaintMode();
        this.lastX = x;
        this.lastY = y;
        this.drawn = true;
    }

    public void endRectangle(Graphics g) {
        g.setXORMode(this.bandColor);
        g.drawRect(this.lastX, this.lastY, this.lastWidth, this.lastHeight);
        g.setPaintMode();
        this.drawn = true;
    }

    public void markErased() {
        this.drawn = false;
    }
}

