/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.JackPartner;
import com.syntona.gui.patch.ModulePartner;
import com.syntona.gui.patch.PatchEditor;
import com.syntona.gui.patch.PatchGlobals;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.Loadable;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.Saveable;
import com.syntona.plugin.SyntonaModule;
import com.syntona.plugin.SyntonaModuleListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.w3c.dom.Element;

public abstract class ModuleView
extends JPanel
implements Saveable,
Loadable {
    protected static final int JACK_HEIGHT = 8;
    protected static final int JACK_WIDTH = 8;
    private PatchEditor patchEditor;
    private SyntonaModule module;
    private boolean selected;
    private JComponent header;
    private static Border notSelectedBorder = BorderFactory.createLineBorder(new Color(0, 0, 0, 0), 4);
    private static Border selectedBorder = BorderFactory.createLineBorder(PatchGlobals.getSelectedColor(), 4);
    private EngineController engine;
    private boolean setupComplete = false;
    private JPopupMenu headerMenu;
    private HashSet<Jack> jacks = new HashSet();
    private ModulePresenter presenter;

    public ModuleView() {
        this.setFocusable(true);
    }

    public ModuleView(ModulePresenter presenter) {
        this.setPresenter(presenter);
    }

    void addJack(Jack jack) {
        this.jacks.add(jack);
    }

    void removeJack(Jack jack) {
        this.jacks.remove(jack);
    }

    boolean containsJack(Jack jack) {
        return this.jacks.contains(jack);
    }

    public void setup(PatchEditor patchEditor, EngineController engine) {
        if (!this.setupComplete) {
            this.patchEditor = patchEditor;
            this.engine = engine;
            this.setLayout(this.makeLayout());
            this.updateSelectedBorder();
            this.setBackground(PatchGlobals.getModuleBackground());
            this.startHeaderMenu();
            this.header = this.makeHeader();
            this.finishHeaderMenu();
            this.makeJacks();
            this.setupComplete = true;
        }
    }

    private void startHeaderMenu() {
        this.headerMenu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Edit...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModuleView.this.presenter.showJackEditor();
            }
        });
        menuItem.setEnabled(this.isEditable());
        this.headerMenu.add(menuItem);
        menuItem = new JMenuItem("Doc...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModuleView.this.presenter.getInfo().getDocumentation().show();
            }
        });
        menuItem.setEnabled(this.presenter.getInfo().getDocumentation() != null);
        this.headerMenu.add(menuItem);
        menuItem = new JMenuItem("Help...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModuleView.this.presenter.getInfo().getHelp().show();
            }
        });
        menuItem.setEnabled(this.presenter.getInfo().getHelp() != null);
        this.headerMenu.add(menuItem);
        menuItem = new JMenuItem("Reset");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModuleView.this.presenter.reset();
            }
        });
        menuItem.setEnabled(this.presenter.isResettable());
        this.headerMenu.add(menuItem);
        menuItem = new JMenuItem("Delete");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SyntonaEngine.getInstance().sendDeleteModule(ModuleView.this.presenter);
            }
        });
        this.headerMenu.add(menuItem);
    }

    private boolean isEditable() {
        return true;
    }

    private void finishHeaderMenu() {
        PopupListener popupListener = new PopupListener();
        this.header.addMouseListener(popupListener);
    }

    public LayoutManager makeLayout() {
        return null;
    }

    public abstract JComponent makeHeader();

    public abstract void makeJacks();

    public PatchEditor getPatchEditor() {
        return this.patchEditor;
    }

    public SyntonaModule getModule() {
        return this.module;
    }

    public void setModule(SyntonaModule module) {
        this.module = module;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        boolean changed = b ^ this.selected;
        this.selected = b;
        if (changed && this.patchEditor != null) {
            this.updateSelectedBorder();
            this.patchEditor.repaint();
        }
    }

    private void updateSelectedBorder() {
        if (this.selected) {
            this.setBorder(selectedBorder);
        } else {
            this.setBorder(notSelectedBorder);
        }
    }

    public void addComponent(JComponent comp) {
        this.addComponent(comp, null, -1);
    }

    public void addComponent(JComponent comp, Object constraints) {
        this.addComponent(comp, constraints, -1);
    }

    public void addComponent(JComponent comp, Object constraints, int index) {
        this.setupPatchComponent(comp);
        this.add(comp, constraints, index);
    }

    public void setupPatchComponent(JComponent comp) {
        if (this.patchEditor != null) {
            comp.addMouseListener(this.patchEditor.getPatchBox());
            comp.addMouseMotionListener(this.patchEditor.getPatchBox());
        }
    }

    protected void setHeader(JComponent header) {
        this.header = header;
    }

    protected JComponent getHeader() {
        return this.header;
    }

    public void edit() {
    }

    protected JPanel createJackBox(Jack jack) {
        JackConnector comp = new JackConnector();
        new JackPartner(comp, this.getPresenter(), jack);
        return comp;
    }

    protected JPanel createJackBox(Jack jack, int x, int y) {
        JPanel comp = this.createJackBox(jack);
        comp.setLocation(x, y);
        return comp;
    }

    protected void addJackBox(Jack jack, int x, int y) {
        JPanel comp = this.createJackBox(jack, x, y);
        this.addComponent(comp);
    }

    protected HeaderBox createHeaderBox() {
        HeaderBox header = new HeaderBox();
        new ModulePartner(header, this.getPresenter());
        return header;
    }

    public ModulePresenter getPresenter() {
        return this.presenter;
    }

    public void setPresenter(ModulePresenter presenter) {
        this.presenter = presenter;
        this.setModule(presenter.getModule());
        this.module.addModuleListener(new SyntonaModuleListener(){

            @Override
            public void jackAdded(SyntonaModule syntonaModule, Jack jack) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ModuleView.this.invalidateSetup();
                    }
                });
            }

            @Override
            public void jackRemoved(SyntonaModule syntonaModule, Jack jack) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ModuleView.this.invalidateSetup();
                    }
                });
            }
        });
    }

    protected void invalidateSetup() {
        this.setupComplete = false;
        this.jacks.clear();
        this.removeAll();
        if (this.patchEditor != null) {
            this.patchEditor.invokeRebuild();
        }
    }

    protected HeaderBox createLeftHeaderBox(int height) {
        HeaderBox header = this.createHeaderBox();
        Insets insets = this.getInsets();
        header.setSize(10, height - insets.top - insets.bottom);
        header.setLocation(insets.left, insets.top);
        return header;
    }

    protected HeaderBox createTopHeaderBox(int width) {
        HeaderBox header = this.createHeaderBox();
        Insets insets = this.getInsets();
        header.setSize(width - insets.left - insets.right, 10);
        header.setLocation(insets.left, insets.top);
        return header;
    }

    public void makeVerticalJackBoxes(int x, int y, int width, int height) {
        int numInputs = this.getModule().getConnectableInputJackCount();
        int numOutputs = this.getModule().getConnectableOutputJackCount();
        int inputIndex = 0;
        int outputIndex = 0;
        int span = height;
        Jack[] jackArray = this.getModule().getJacks();
        int n = jackArray.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            if (jack.isConnectable()) {
                int yj;
                if (jack instanceof InputJack) {
                    yj = y + (inputIndex * 2 + 1) * span / (2 * numInputs);
                    this.addJackBox(jack, x, yj -= 4);
                    ++inputIndex;
                } else {
                    yj = y + (outputIndex * 2 + 1) * span / (2 * numOutputs);
                    this.addJackBox(jack, x + width - 8, yj -= 4);
                    ++outputIndex;
                }
            }
            ++n2;
        }
    }

    protected void makeVerticalJackBoxes() {
        Insets insets = this.getInsets();
        this.makeVerticalJackBoxes(insets.left, insets.top + 10, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom - 10);
    }

    public EngineController getEngineController() {
        return this.engine;
    }

    @Override
    public void save(SyntonaSaver saver, boolean topLevel) {
        Rectangle bounds = new Rectangle();
        bounds.x = this.getLocation().x;
        bounds.y = this.getLocation().y;
        bounds.width = this.getWidth();
        bounds.height = this.getHeight();
        saver.saveBounds(bounds);
    }

    public void load(SyntonaLoader loader, Element moduleElement) {
        Rectangle bounds = loader.loadBounds(moduleElement);
        if (bounds != null) {
            this.setSize(new Dimension(bounds.width, bounds.height));
            bounds.x += loader.getOffsetX();
            bounds.y += loader.getOffsetY();
            SyntonaEngine.getInstance().sendMoveModule(this.getModule().getId(), bounds.x, bounds.y);
        }
    }

    public JFrame getFrame() {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof JFrame) {
                return (JFrame)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void updateName() {
    }

    public void setXY(int x, int y) {
        super.setLocation(x, y);
    }

    static class JackConnector
    extends JPanel {
        static final Color color = new Color(50, 50, 60);

        JackConnector() {
            Dimension dimension = new Dimension(8, 8);
            this.setSize(dimension);
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension);
            this.setMaximumSize(dimension);
            this.setBackground(color);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ModuleView.this.headerMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                ModuleView.this.presenter.showMainEditor();
            }
        }
    }
}

