/*
 * Decompiled with CFR 0.152.
 */
package com.syntona;

import com.syntona.gui.EasyFileChooser;
import com.syntona.gui.SyntonaFrame;
import com.syntona.gui.patch.PatchEditor;
import com.syntona.model.GUIService;
import com.syntona.plugin.ModulePresenter;
import java.awt.event.KeyListener;
import java.io.File;

public class SyntonaGUIService
implements GUIService {
    private SyntonaFrame syntonaFrame;

    public SyntonaGUIService(SyntonaFrame frame) {
        this.syntonaFrame = frame;
    }

    @Override
    public File askSaveFile(File lastFile) {
        return EasyFileChooser.chooseSaveFileXML("Select a folder and a name for saving.", this.syntonaFrame, lastFile);
    }

    @Override
    public File askSaveFile(File lastFile, String suffix) {
        return EasyFileChooser.chooseSaveFile("Select a folder and a name for saving.", this.syntonaFrame, lastFile, suffix);
    }

    @Override
    public File askOpenFileXML(File lastFile) {
        return EasyFileChooser.chooseOpenFileXML("Select a file to load a patch from.", this.syntonaFrame, lastFile);
    }

    @Override
    public File askOpenFile(File lastFile, String suffix) {
        return EasyFileChooser.chooseOpenFile("Select a " + suffix + " file to load.", this.syntonaFrame, lastFile, suffix);
    }

    @Override
    public ModulePresenter[] getSelectedModulePresenters() {
        PatchEditor editor = this.getFrontPatchEditor();
        if (editor == null) {
            return null;
        }
        return editor.getPatchBox().getSelectedModulePresenters();
    }

    private PatchEditor getFrontPatchEditor() {
        return this.syntonaFrame.getFrontPatchEditor();
    }

    @Override
    public void addPlayKeyListener(KeyListener listener) {
        this.syntonaFrame.addPlayKeyListener(listener);
    }

    @Override
    public void removePlayKeyListener(KeyListener listener) {
        this.syntonaFrame.removePlayKeyListener(listener);
    }

    @Override
    public void setPlayKeysOverride(boolean b) {
        this.syntonaFrame.setPlayKeysOverride(b);
    }
}

