/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class IndentingWriter
extends PrintWriter {
    int spacesPerIndentation = 4;
    int indentation = 0;
    int position = 0;

    public IndentingWriter(OutputStream stream) {
        super(stream, true);
    }

    public IndentingWriter(Writer outputStreamWriter) {
        super(outputStreamWriter, true);
    }

    public void setIndentation(int level) {
        this.indentation = level;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void indent() {
        ++this.indentation;
    }

    public void undent() {
        --this.indentation;
        if (this.indentation < 0) {
            this.indentation = 0;
        }
    }

    @Override
    public void print(String s) {
        if (this.position == 0) {
            int numSpaces = this.indentation * this.spacesPerIndentation;
            int i = 0;
            while (i < numSpaces) {
                this.print(' ');
                ++i;
            }
            this.position += numSpaces;
        }
        super.print(s);
        this.position += s.length();
    }

    @Override
    public void println() {
        super.println();
        this.position = 0;
    }

    @Override
    public void println(String s) {
        this.print(s);
        this.println();
    }
}

