/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.Column;
import com.softsynth.score.Score;
import com.softsynth.score.ScoreList;
import com.softsynth.score.ScoreNote;
import com.softsynth.score.Sequence;

public class ScoreParser {
    private int cursor;

    public Score parse(String text) {
        this.cursor = 0;
        Score score = new Score();
        this.parse(score, text);
        return score;
    }

    private void parse(ScoreList container, String text) {
        while (this.cursor < text.length()) {
            Sequence sequence;
            char c;
            if ((c = text.charAt(this.cursor++)) == '{') {
                sequence = new Sequence();
                this.parse(sequence, text);
                container.add(sequence);
                continue;
            }
            if (c == '}') {
                if (!(container instanceof Sequence)) {
                    throw new RuntimeException("{} imbalance!");
                }
                sequence = (Sequence)container;
                if (this.cursor >= text.length() || text.charAt(this.cursor) != '*') break;
                ++this.cursor;
                int repeat = this.parseInteger(text);
                sequence.setRepeatCount(repeat);
                break;
            }
            if (c == '[') {
                Column column = new Column();
                this.parse(column, text);
                container.add(column);
                continue;
            }
            if (c == ']') break;
            if (c == ' ') continue;
            --this.cursor;
            ScoreNote scoreNote = new ScoreNote();
            this.parse(scoreNote, text);
            container.add(scoreNote);
        }
    }

    private void parse(ScoreNote scoreNote, String text) {
        if (text.charAt(this.cursor) == '#') {
            ++this.cursor;
        }
        double numerator = this.parseInteger(text);
        if (text.charAt(this.cursor++) != '/') {
            throw new RuntimeException("Not a ratio!");
        }
        double denominator = this.parseInteger(text);
        double ratio = numerator / denominator;
        scoreNote.setValue(ratio);
    }

    private int parseInteger(String text) {
        StringBuffer buffer = new StringBuffer();
        while (this.cursor < text.length()) {
            char ch;
            if (Character.isDigit(ch = text.charAt(this.cursor++))) {
                buffer.append(ch);
                continue;
            }
            --this.cursor;
            break;
        }
        String s = buffer.toString();
        return Integer.parseInt(s);
    }
}

