/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.compose.swing.BasicScoreInstrument;
import com.softsynth.score.JSynScoreClock;
import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScoreNote;
import com.softsynth.score.ScorePlayer;
import com.softsynth.score.ScoreQueue;
import com.softsynth.score.Sequence;

public class PlayScoreQueue {
    private static final int NOTES_PER_MEASURE = 4;
    private static final int MAX_VOICES = 8;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private double advance = 0.2;
    private SubtractiveSynthVoice[] voices;

    private void test() throws InterruptedException {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.voices = new SubtractiveSynthVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(0, this.lineOut.input, 0);
            voice.getOutput().connect(0, this.lineOut.input, 1);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.synth.start();
        this.lineOut.start();
        JSynScoreClock clock = new JSynScoreClock(this.synth);
        ScorePlayer scorePlayer = new ScorePlayer(clock);
        scorePlayer.setAdvance(this.advance);
        ScoreQueue queue = new ScoreQueue();
        BasicScoreInstrument instrument = new BasicScoreInstrument(clock, this.allocator);
        queue.setInstrument(instrument);
        double duration = 0.25;
        this.addMeasure(queue, duration);
        int measureCount = 0;
        double timeNow = clock.getScoreTime();
        double nextTime = timeNow + this.advance;
        double measureDuration = duration * 4.0;
        double nextComposeTime = nextTime + measureDuration / 2.0;
        ScoreElementPlayer elementPlayer = queue.start(null, nextTime);
        while (!elementPlayer.isDone()) {
            System.out.println("Loop: nextTime = " + nextTime + ", nextComposeTime = " + nextComposeTime);
            if (nextTime > nextComposeTime && measureCount < 6) {
                this.addMeasure(queue, duration);
                ++measureCount;
                nextComposeTime += measureDuration;
            }
            scorePlayer.waitUntil(nextTime);
            nextTime = elementPlayer.advance(nextTime);
        }
        System.out.println("Finished playing.");
        this.synth.sleepFor(1.0);
        this.synth.stop();
    }

    private void addMeasure(ScoreQueue queue, double duration) {
        System.out.println("Add another measure.");
        Sequence sequence = new Sequence();
        sequence.add(new ScoreNote(duration, 60.0));
        sequence.add(this.createRandomNote(duration));
        sequence.add(this.createRandomNote(duration));
        sequence.add(this.createRandomNote(duration));
        queue.add(sequence);
    }

    private ScoreElement createRandomNote(double duration) {
        double pitch = 72 + (int)(Math.random() * 12.0);
        return new ScoreNote(duration, pitch);
    }

    public static void main(String[] args) {
        try {
            new PlayScoreQueue().test();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

