/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.io.AudioInputStream;
import com.jsyn.io.AudioOutputStream;
import com.jsyn.util.TransportModel;
import java.io.IOException;

public class StreamingThread
extends Thread {
    private AudioInputStream inputStream;
    private AudioOutputStream outputStream;
    private int framesPerBuffer = 1024;
    private volatile boolean go = true;
    private TransportModel transportModel;
    private long framePosition;
    private long maxFrames;
    private int samplesPerFrame = 1;

    public StreamingThread(AudioInputStream inputStream, AudioOutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public void run() {
        double[] buffer = new double[this.framesPerBuffer * this.samplesPerFrame];
        try {
            this.transportModel.firePositionChanged(this.framePosition);
            this.transportModel.fireStateChanged(2);
            int framesToRead = this.getFramesToRead(buffer);
            while (this.go && framesToRead > 0) {
                int samplesToRead = framesToRead * this.samplesPerFrame;
                while (samplesToRead > 0) {
                    int samplesRead = this.inputStream.read(buffer, 0, samplesToRead);
                    this.outputStream.write(buffer, 0, samplesRead);
                    if (samplesRead < (samplesToRead -= samplesRead)) break;
                }
                this.framePosition += (long)framesToRead;
                this.transportModel.firePositionChanged(this.framePosition);
                framesToRead = this.getFramesToRead(buffer);
            }
            this.transportModel.fireStateChanged(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getFramesToRead(double[] buffer) {
        if (this.maxFrames > 0L) {
            long numToRead = this.maxFrames - this.framePosition;
            if (numToRead < 0L) {
                return 0;
            }
            if (numToRead > (long)this.framesPerBuffer) {
                numToRead = this.framesPerBuffer;
            }
            return (int)numToRead;
        }
        return this.framesPerBuffer;
    }

    public int getFramesPerBuffer() {
        return this.framesPerBuffer;
    }

    public void setFramesPerBuffer(int framesPerBuffer) {
        this.framesPerBuffer = framesPerBuffer;
    }

    public void requestStop() {
        this.go = false;
    }

    public TransportModel getTransportModel() {
        return this.transportModel;
    }

    public void setTransportModel(TransportModel transportModel) {
        this.transportModel = transportModel;
    }

    public void setMaxFrames(long maxFrames) {
        this.maxFrames = maxFrames;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setSamplesPerFrame(int samplesPerFrame) {
        this.samplesPerFrame = samplesPerFrame;
    }
}

