/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.util.NumericOutput;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleBoundedRangeSlider
extends JSlider {
    private static final long serialVersionUID = -440390322602838998L;
    private int places;

    public DoubleBoundedRangeSlider(DoubleBoundedRangeModel model) {
        this(model, 5);
    }

    public DoubleBoundedRangeSlider(DoubleBoundedRangeModel model, int places) {
        super(model);
        this.places = places;
        this.setBorder(BorderFactory.createTitledBorder(this.generateTitleText()));
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DoubleBoundedRangeSlider.this.updateTitle();
            }
        });
    }

    protected void updateTitle() {
        TitledBorder border = (TitledBorder)this.getBorder();
        if (border != null) {
            border.setTitle(this.generateTitleText());
            this.repaint();
        }
    }

    String generateTitleText() {
        DoubleBoundedRangeModel model = (DoubleBoundedRangeModel)this.getModel();
        double val = model.getDoubleValue();
        String valText = NumericOutput.doubleToString(val, 0, this.places);
        return String.valueOf(model.getName()) + " = " + valText;
    }

    public void makeStandardLabels(int labelSpacing) {
        this.setMajorTickSpacing(labelSpacing / 2);
        this.setLabelTable(this.createStandardLabels(labelSpacing));
        this.setPaintTicks(true);
        this.setPaintLabels(true);
    }

    public double nextLabelValue(double current, double delta) {
        return current + delta;
    }

    public void makeLabels(double start, double delta, int places) {
        DoubleBoundedRangeModel model = (DoubleBoundedRangeModel)this.getModel();
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        double dval = start;
        while (dval <= model.getDoubleMaximum()) {
            int sliderValue = model.doubleToSlider(dval);
            String text = NumericOutput.doubleToString(dval, 0, places);
            labelTable.put(sliderValue, new JLabel(text));
            dval = this.nextLabelValue(dval, delta);
        }
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
    }
}

