/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.ports;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.ConnectableOutput;
import com.jsyn.ports.UnitBlockPort;
import com.softsynth.shared.time.ScheduledCommand;
import com.softsynth.shared.time.TimeStamp;
import java.util.ArrayList;

public class PortBlockPart
implements ConnectableOutput,
ConnectableInput {
    private double[] values = new double[8];
    private ArrayList<PortBlockPart> connections = new ArrayList();
    private UnitBlockPort unitBlockPort;

    protected PortBlockPart(UnitBlockPort unitBlockPort, double defaultValue) {
        this.unitBlockPort = unitBlockPort;
        this.setValue(defaultValue);
    }

    public double[] getValues() {
        return this.values;
    }

    public double getValue() {
        return this.values[0];
    }

    public double get() {
        return this.values[0];
    }

    protected void setValue(double value) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = value;
            ++i;
        }
    }

    protected boolean isConnected() {
        return this.connections.size() > 0;
    }

    private void addConnection(PortBlockPart otherPart) {
        if (!this.connections.contains(otherPart)) {
            this.connections.add(otherPart);
        }
    }

    private void removeConnection(PortBlockPart otherPart) {
        this.connections.remove(otherPart);
    }

    private void connectNow(PortBlockPart otherPart) {
        this.addConnection(otherPart);
        otherPart.addConnection(this);
    }

    private void disconnectNow(PortBlockPart otherPart) {
        this.removeConnection(otherPart);
        otherPart.removeConnection(this);
    }

    private void disconnectAllNow() {
        for (PortBlockPart part : this.connections) {
            part.removeConnection(this);
        }
        this.connections.clear();
    }

    public PortBlockPart getConnection(int i) {
        return this.connections.get(i);
    }

    public int getConnectionCount() {
        return this.connections.size();
    }

    protected void flatten() {
        double lastValue = this.values[this.values.length - 1];
        int i = 0;
        while (i < this.values.length - 1) {
            this.values[i] = lastValue;
            ++i;
        }
    }

    protected UnitBlockPort getPort() {
        return this.unitBlockPort;
    }

    private void checkConnection(PortBlockPart destination) {
        SynthesisEngine destSynth;
        SynthesisEngine sourceSynth = this.unitBlockPort.getSynthesisEngine();
        if (sourceSynth != (destSynth = destination.unitBlockPort.getSynthesisEngine()) && sourceSynth != null && destSynth != null) {
            throw new RuntimeException("Connection between units on different synths.");
        }
    }

    protected void connect(final PortBlockPart destination) {
        this.checkConnection(destination);
        this.unitBlockPort.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                PortBlockPart.this.connectNow(destination);
            }
        });
    }

    protected void connect(final PortBlockPart destination, TimeStamp timeStamp) {
        this.unitBlockPort.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                PortBlockPart.this.connectNow(destination);
            }
        });
    }

    protected void disconnect(final PortBlockPart destination) {
        this.unitBlockPort.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                PortBlockPart.this.disconnectNow(destination);
            }
        });
    }

    protected void disconnect(final PortBlockPart destination, TimeStamp timeStamp) {
        this.unitBlockPort.scheduleCommand(timeStamp, new ScheduledCommand(){

            @Override
            public void run() {
                PortBlockPart.this.disconnectNow(destination);
            }
        });
    }

    protected void disconnectAll() {
        this.unitBlockPort.queueCommand(new ScheduledCommand(){

            @Override
            public void run() {
                PortBlockPart.this.disconnectAllNow();
            }
        });
    }

    @Override
    public void connect(ConnectableInput other) {
        this.connect(other.getPortBlockPart());
    }

    @Override
    public void connect(ConnectableOutput other) {
        other.connect(this);
    }

    @Override
    public void disconnect(ConnectableOutput other) {
        other.disconnect(this);
    }

    @Override
    public void disconnect(ConnectableInput other) {
        this.disconnect(other.getPortBlockPart());
    }

    @Override
    public PortBlockPart getPortBlockPart() {
        return this;
    }

    @Override
    public void pullData(long frameCount, int start, int limit) {
        int i = 0;
        while (i < this.getConnectionCount()) {
            PortBlockPart part = this.getConnection(i);
            part.getPort().getUnitGenerator().pullData(frameCount, start, limit);
            ++i;
        }
    }
}

