/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.swing.ExponentialRangeModel;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.swing.PortModelFactory;
import com.jsyn.swing.RotaryTextController;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.GridLayout;
import javax.swing.JApplet;
import javax.swing.JPanel;

public class SawFaders
extends JApplet {
    private Synthesizer synth;
    private UnitOscillator osc;
    private LinearRamp lag;
    private LineOut lineOut;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.lag = new LinearRamp();
        this.synth.add(this.lag);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.lag.output.connect(this.osc.amplitude);
        this.lag.input.setup(0.0, 0.5, 1.0);
        this.lag.time.set(0.2);
        this.setLayout(new GridLayout(0, 1));
        ExponentialRangeModel amplitudeModel = PortModelFactory.createExponentialModel(this.lag.input);
        RotaryTextController knob = new RotaryTextController(amplitudeModel, 5);
        JPanel knobPanel = new JPanel();
        knobPanel.add(knob);
        this.add(knobPanel);
        this.osc.frequency.setup(50.0, 300.0, 10000.0);
        this.add(PortControllerFactory.createExponentialPortSlider(this.osc.frequency));
        this.validate();
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] args) {
        SawFaders applet = new SawFaders();
        JAppletFrame frame = new JAppletFrame("SawFaders", applet);
        frame.setSize(440, 200);
        frame.setVisible(true);
        frame.test();
    }
}

