/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitInputPort;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.core.PatchModule;
import com.syntona.model.jsyn.InputAudioJack;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.model.jsyn.UnitPortModule;
import com.syntona.plugin.CopyConnectionHandler;
import com.syntona.plugin.Jack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class AudioInputJackModule
extends UnitPortModule {
    private final OutputAudioJack output = new OutputAudioJack((SyntonaModule)this, "output", "signal from parent");
    InputAudioJack input;

    public AudioInputJackModule(int numParts) {
        super(numParts);
        this.output.setSynthPort(this.tiePoint.output);
    }

    public AudioInputJackModule() {
        this(1);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.input != null) {
            this.input.setName(name);
            this.input.setDefaultText(name);
        }
    }

    @Override
    public void removedFromPatch() {
        this.getParent().removeJack(this.input);
        super.removedFromPatch();
    }

    @Override
    public void addedToPatch(PatchModule parent) {
        super.addedToPatch(parent);
        this.input = new InputAudioJack(parent, this.getName(), this.tiePoint.input, 0){

            @Override
            public void passMessage(PatchMessage msg) {
                AudioInputJackModule.this.output.passMessage(msg);
                super.passMessage(msg);
            }
        };
        this.input.setHelp("input to patch");
        this.output.setConnectionHandler(new CopyConnectionHandler(this.input));
    }

    @Override
    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        saver.beginElement("proxy");
        this.input.saveAttributes(saver);
        saver.endElement();
    }

    @Override
    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException {
        Element inputElement;
        if (this.input != null && (inputElement = XMLDOMLoader.getChildByTagName(moduleElement, "proxy")) != null) {
            this.input.loadContents(inputElement);
        }
    }

    @Override
    public boolean validateExport() {
        boolean ok = super.validateExport();
        String exportedName = this.input.getName();
        if (!SyntonaExporter.validateExportedName(exportedName)) {
            ok = false;
        }
        return ok;
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                exporter.addClass(UnitInputPort.class);
                break;
            }
            case 2: {
                writer.println("public UnitInputPort " + this.input.getName() + ";");
                break;
            }
            case 4: {
                writer.println("addPort(" + this.input.getName() + " = " + this.getExportedObjectName() + ".input, \"" + this.input.getName() + "\");");
                break;
            }
            case 6: {
                double max;
                UnitInputPort inPort = this.input.getUnitInputPort();
                double min = inPort.getMinimum();
                double value = inPort.getValue();
                if (min > value) {
                    min = value <= 0.0 ? 2.0 * value : 0.5 * value;
                }
                if ((max = inPort.getMaximum()) < value) {
                    max = value <= 0.0 ? 0.5 * value : 2.0 * value;
                }
                writer.println(String.valueOf(this.input.getName()) + ".setup(" + min + ", " + value + ", " + max + ");");
                break;
            }
            case 8: {
                if ("frequency".equals(this.getName().toLowerCase())) {
                    writer.println("this.frequency.set(frequency, timeStamp);");
                    break;
                }
                if (!"amplitude".equals(this.getName().toLowerCase())) break;
                writer.println("this.amplitude.set(amplitude, timeStamp);");
            }
        }
    }

    @Override
    public void noteOn(double frequency, double amplitude) {
        if ("frequency".equals(this.getName().toLowerCase())) {
            this.input.setValue(frequency);
        } else if ("amplitude".equals(this.getName().toLowerCase())) {
            this.input.setValue(amplitude);
        }
    }

    @Override
    public Jack[] getJacksToEdit() {
        Jack[] jacksToEdit = new Jack[]{this.input};
        return jacksToEdit;
    }
}

