/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PlayOverrideFocusListener;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.core.CommentModule;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.SyntonaModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.w3c.dom.Element;

public class CommentModuleView
extends ModuleView {
    private static final int HEIGHT = 60;
    private static final int WIDTH = 250;
    private static final String TAG_TEXT = "text";
    private JTextArea textArea;
    private JScrollPane scrollPane;

    private void setup() {
        this.setSize(250, 60);
        this.textArea = new JTextArea();
    }

    public CommentModuleView() {
        this.setup();
    }

    public CommentModuleView(ModulePresenter presenter) {
        super(presenter);
        this.setup();
    }

    @Override
    public void setModule(SyntonaModule module) {
        super.setModule(module);
        CommentModule commentModule = (CommentModule)module;
        commentModule.setTextSource(new CommentModule.ITextSource(){

            @Override
            public String getText() {
                return CommentModuleView.this.textArea.getText();
            }
        });
    }

    @Override
    public LayoutManager makeLayout() {
        return new BorderLayout();
    }

    @Override
    public void makeJacks() {
        this.textArea.addFocusListener(new PlayOverrideFocusListener());
        this.textArea.setAutoscrolls(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                CommentModuleView.this.updateSize();
                CommentModuleView.this.getPresenter().markDirty();
            }
        });
        this.add((Component)this.scrollPane, "Center");
    }

    @Override
    public JComponent makeHeader() {
        HeaderBox header = this.createHeaderBox();
        this.setupPatchComponent(header);
        this.add((Component)header, "North");
        return header;
    }

    private void updateSize() {
        Dimension scrollSize = this.scrollPane.getSize();
        Dimension scrollPreferredSize = this.scrollPane.getPreferredSize();
        Dimension viewSize = this.getSize();
        viewSize.height += scrollPreferredSize.height - scrollSize.height;
        this.setSize(viewSize);
        this.validate();
    }

    @Override
    public void save(SyntonaSaver saver, boolean topLevel) {
        super.save(saver, topLevel);
        saver.beginElement(TAG_TEXT);
        saver.addContent(this.textArea.getText());
        saver.endElement();
    }

    @Override
    public void load(SyntonaLoader loader, Element moduleElement) {
        super.load(loader, moduleElement);
        Element textElement = XMLDOMLoader.getChildByTagName(moduleElement, TAG_TEXT);
        if (textElement != null) {
            String text = textElement.getTextContent();
            this.textArea.setText(text);
        }
    }
}

