/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.syntona.model.SyntonaSaver;
import java.io.File;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLDOMSaver
extends SyntonaSaver {
    Document document;
    Stack<Element> elementStack;
    private static final Logger logger = Logger.getLogger(XMLDOMSaver.class.getName());
    private File targetFile;

    public XMLDOMSaver() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        this.document = parser.newDocument();
        this.elementStack = new Stack();
    }

    Document getDocument() {
        return this.document;
    }

    @Override
    public void render(File saveFile) {
        StreamResult dest = new StreamResult(saveFile);
        this.transform(dest);
    }

    @Override
    public void render(Result result) {
        this.transform(result);
    }

    @Override
    public void print() {
        StreamResult dest = new StreamResult(System.out);
        this.transform(dest);
    }

    private void transform(Result result) throws TransformerFactoryConfigurationError, IllegalArgumentException {
        TransformerFactory tranFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = tranFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(this.document);
            transformer.transform(src, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addAttribute(String name, String value) {
        this.elementStack.peek().setAttribute(name, value);
    }

    @Override
    public void addAttribute(String name, double value) {
        this.addAttribute(name, "" + value);
    }

    @Override
    public void addAttribute(String name, int value) {
        this.addAttribute(name, "" + value);
    }

    @Override
    public void addAttribute(String name, boolean flag) {
        this.addAttribute(name, flag ? "true" : "false");
    }

    @Override
    public void beginElement(String name) {
        logger.fine("stack depth = " + this.elementStack.size() + ", name is " + name);
        Element element = this.document.createElement(name);
        if (this.elementStack.isEmpty()) {
            this.document.appendChild(element);
        } else {
            this.elementStack.peek().appendChild(element);
        }
        this.elementStack.push(element);
    }

    @Override
    public void endElement() {
        this.elementStack.pop();
    }

    @Override
    public File getTargetFile() {
        return this.targetFile;
    }

    @Override
    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    @Override
    public void addContent(String text) {
        this.elementStack.peek().setTextContent(text);
    }
}

