/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;

public class KeyDispatchOnCapsLock
extends JCheckBox {
    private static final String TEXT_BASE = "Play Keys (CapsLock)";
    private ArrayList<KeyListener> playKeyListeners = new ArrayList();
    private boolean override;

    public KeyDispatchOnCapsLock() {
        super(TEXT_BASE);
        KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean enabled;
                boolean handled = false;
                boolean bl = enabled = !KeyDispatchOnCapsLock.this.override && KeyDispatchOnCapsLock.this.isSelected();
                if (e.getKeyCode() == 20) {
                    if (e.getID() == 401) {
                        KeyDispatchOnCapsLock.this.setSelected(true);
                    } else if (e.getID() == 402) {
                        KeyDispatchOnCapsLock.this.setSelected(false);
                    }
                    handled = true;
                } else if (enabled) {
                    char ch = e.getKeyChar();
                    int mods = e.getModifiers();
                    if (mods == 0 && Character.isLetterOrDigit(ch)) {
                        KeyDispatchOnCapsLock.this.firePlayKeyListeners(e);
                        handled = true;
                    }
                }
                if (handled) {
                    e.consume();
                }
                return handled;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(keyEventDispatcher);
    }

    public void addPlayKeyListener(KeyListener listener) {
        this.playKeyListeners.add(listener);
    }

    public void removePlayKeyListener(KeyListener listener) {
        this.playKeyListeners.remove(listener);
    }

    private void firePlayKeyListeners(KeyEvent e) {
        for (KeyListener listener : this.playKeyListeners) {
            if (e.getID() == 401) {
                listener.keyPressed(e);
                continue;
            }
            if (e.getID() == 402) {
                listener.keyReleased(e);
                continue;
            }
            if (e.getID() != 400) continue;
            listener.keyTyped(e);
        }
    }

    public void setPlayKeysOverride(boolean b) {
        this.override = b;
    }
}

