/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui;

import com.syntona.gui.AlertUser;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class EasyFileChooser {
    private static File chooseTypedDirectory(String message, JFrame frame, File defaultFile, int dialogType) {
        int returnVal;
        File file = null;
        JFileChooser chooser = new JFileChooser(defaultFile);
        chooser.setDialogType(dialogType);
        chooser.setFileSelectionMode(1);
        chooser.setSelectedFile(defaultFile);
        if (message != null) {
            chooser.setDialogTitle(message);
        }
        if ((returnVal = chooser.showOpenDialog(frame)) == 0) {
            String fileName = chooser.getSelectedFile().getName();
            file = new File(chooser.getCurrentDirectory(), fileName);
        }
        return file;
    }

    public static File chooseOpenDirectory(String message, JFrame frame, File defaultFile) {
        return EasyFileChooser.chooseTypedDirectory(message, frame, defaultFile, 0);
    }

    public static File chooseSaveDirectory(String message, JFrame frame, File defaultFile) {
        return EasyFileChooser.chooseTypedDirectory(message, frame, defaultFile, 0);
    }

    private static File getFileFromDialog(FileDialog fileDlg) {
        String dirName = fileDlg.getDirectory();
        String fileName = fileDlg.getFile();
        if (fileName != null && dirName != null) {
            fileName = String.valueOf(dirName) + fileName;
            return new File(fileName);
        }
        return null;
    }

    private static FileDialog prepareFileDialog(String message, Frame frame, File defaultFile, String pSuffix, int mode) {
        final String suffix = pSuffix.toLowerCase();
        FileDialog fileDlg = new FileDialog(frame, message, mode);
        if (suffix != null) {
            fileDlg.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(suffix);
                }
            });
        }
        if (defaultFile != null) {
            fileDlg.setDirectory(defaultFile.getParent());
            fileDlg.setFile(defaultFile.getName());
        }
        return fileDlg;
    }

    private static File chooseFileAWT(String message, Frame frame, File defaultFile, String pSuffix, int mode) {
        FileDialog fileDlg = EasyFileChooser.prepareFileDialog(message, frame, defaultFile, pSuffix, mode);
        String lSuffix = pSuffix.toLowerCase();
        boolean validName = false;
        do {
            fileDlg.show();
            String fileName = fileDlg.getFile();
            boolean bl = validName = fileName == null || fileName.toLowerCase().endsWith(lSuffix);
            if (validName) continue;
            fileDlg.setFile(String.valueOf(fileName) + lSuffix);
            AlertUser.showError((Component)frame, "File name must end with " + lSuffix);
        } while (!validName);
        return EasyFileChooser.getFileFromDialog(fileDlg);
    }

    public static File chooseSaveFileAWT(String message, Frame frame, File defaultFile, String pSuffix) {
        String lSuffix = pSuffix.toLowerCase();
        FileDialog fileDlg = EasyFileChooser.prepareFileDialog(message, frame, defaultFile, lSuffix, 1);
        boolean validName = false;
        do {
            fileDlg.setVisible(true);
            String fileName = fileDlg.getFile();
            boolean bl = validName = fileName == null || fileName.toLowerCase().endsWith(lSuffix);
            if (validName) continue;
            if (fileName.contains(".")) {
                fileDlg.setFile(String.valueOf(fileName) + lSuffix);
                AlertUser.showError((Component)frame, "File name must end with " + lSuffix);
                continue;
            }
            fileDlg.setFile(String.valueOf(fileName) + lSuffix);
            break;
        } while (!validName);
        return EasyFileChooser.getFileFromDialog(fileDlg);
    }

    public static File chooseSaveFile(String message, JFrame frame, File defaultFile) {
        return EasyFileChooser.chooseSaveFile(message, frame, defaultFile, null);
    }

    public static File chooseSaveFile(String message, JFrame frame, File defaultFile, String suffix) {
        return EasyFileChooser.chooseSaveFileAWT(message, frame, defaultFile, suffix);
    }

    public static File chooseSaveFileXML(String message, JFrame frame, File defaultFile) {
        return EasyFileChooser.chooseSaveFileAWT(message, frame, defaultFile, ".xml");
    }

    public static File chooseOpenFileAWT(String message, Frame frame, File defaultFile, String pSuffix) {
        String lSuffix = pSuffix.toLowerCase();
        FileDialog fileDlg = EasyFileChooser.prepareFileDialog(message, frame, defaultFile, lSuffix, 0);
        fileDlg.show();
        return EasyFileChooser.getFileFromDialog(fileDlg);
    }

    public static File chooseOpenFileXML(String message, JFrame splashFrame, File defaultFile) {
        return EasyFileChooser.chooseOpenFileAWT(message, splashFrame, defaultFile, ".xml");
    }

    public static File chooseOpenFile(String message, JFrame splashFrame, File defaultFile, String suffix) {
        return EasyFileChooser.chooseOpenFileAWT(message, splashFrame, defaultFile, suffix);
    }
}

