/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.util;

public class XMLTools {
    public static String replaceCharacters(String text, int ch, String newText) {
        int index = text.indexOf(ch);
        if (index < 0) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        index = 0;
        while (index < text.length()) {
            char cs = text.charAt(index);
            if (cs == ch) {
                buffer.append(newText);
            } else {
                buffer.append(cs);
            }
            ++index;
        }
        return buffer.toString();
    }

    public static String escapeText(String text) {
        text = XMLTools.replaceCharacters(text, 38, "&amp;");
        text = XMLTools.replaceCharacters(text, 60, "&lt;");
        text = XMLTools.replaceCharacters(text, 62, "&gt;");
        text = XMLTools.replaceCharacters(text, 34, "&quot;");
        text = XMLTools.replaceCharacters(text, 39, "&apos;");
        return text;
    }

    public static String unescapeText(String text) {
        int index = text.indexOf(38);
        if (index < 0) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        index = 0;
        while (index < text.length()) {
            char cs = text.charAt(index);
            if (cs == '&') {
                int indexSemiColon = text.indexOf(59, index);
                if (indexSemiColon < 0) break;
                String repStr = null;
                String escape = text.substring(index + 1, indexSemiColon);
                if (escape.equals("amp")) {
                    repStr = "&";
                } else if (escape.equals("lt")) {
                    repStr = "<";
                } else if (escape.equals("gt")) {
                    repStr = ">";
                } else if (escape.equals("quot")) {
                    repStr = "\"";
                } else if (escape.equals("apos")) {
                    repStr = "'";
                }
                if (repStr != null) {
                    buffer.append(repStr);
                }
                index = indexSemiColon;
            } else {
                buffer.append(cs);
            }
            ++index;
        }
        return buffer.toString();
    }

    public static void testText(String text1) {
        String text2 = XMLTools.escapeText(text1);
        String text3 = XMLTools.unescapeText(text2);
        System.out.println("Convert     \"" + text1 + "\"");
        System.out.println("to          \"" + text2 + "\"");
        System.out.println("and back to \"" + text3 + "\"");
    }

    public static void main(String[] argv) {
        XMLTools.testText("Is 2 < 3 or is 2 > 3 ?");
        XMLTools.testText("Joe's & Fred's <<<wow>>> use quotes \"hey bob\"");
    }
}

