/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.Synthesizer;
import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.ConnectableInput;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitPort;
import com.jsyn.unitgen.Circuit;
import com.softsynth.shared.time.TimeStamp;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnitGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitGenerator.class);
    protected static final double VERY_SMALL_FLOAT = 1.0E-26;
    public static final String PORT_NAME_INPUT = "Input";
    public static final String PORT_NAME_OUTPUT = "Output";
    public static final String PORT_NAME_PHASE = "Phase";
    public static final String PORT_NAME_FREQUENCY = "Frequency";
    public static final String PORT_NAME_FREQUENCY_SCALER = "FreqScaler";
    public static final String PORT_NAME_AMPLITUDE = "Amplitude";
    public static final String PORT_NAME_PAN = "Pan";
    public static final String PORT_NAME_TIME = "Time";
    public static final String PORT_NAME_CUTOFF = "Cutoff";
    public static final String PORT_NAME_PRESSURE = "Pressure";
    public static final String PORT_NAME_TIMBRE = "Timbre";
    public static final double FALSE = 0.0;
    public static final double TRUE = 1.0;
    protected SynthesisEngine synthesisEngine;
    private final LinkedHashMap<String, UnitPort> ports = new LinkedHashMap();
    private Circuit circuit;
    private long lastFrameCount;
    private boolean enabled = true;
    private static int nextId;
    private final int id = nextId++;

    public int getId() {
        return this.id;
    }

    public int getFrameRate() {
        return this.synthesisEngine.getFrameRate();
    }

    public double getFramePeriod() {
        return this.synthesisEngine.getFramePeriod();
    }

    public void addPort(UnitPort port) {
        port.setUnitGenerator(this);
        this.ports.put(port.getName().toLowerCase(), port);
    }

    public void addPort(UnitPort port, String name) {
        port.setName(name);
        this.addPort(port);
    }

    public UnitPort getPortByName(String portName) {
        return this.ports.get(portName.toLowerCase());
    }

    public Collection<UnitPort> getPorts() {
        return this.ports.values();
    }

    public abstract void generate(int var1, int var2);

    public void generate() {
        this.generate(0, 8);
    }

    public SynthesisEngine getSynthesisEngine() {
        return this.synthesisEngine;
    }

    public Synthesizer getSynthesizer() {
        return this.synthesisEngine;
    }

    public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
        if (this.synthesisEngine != null && this.synthesisEngine != synthesisEngine) {
            throw new RuntimeException("Unit synthesisEngine already set.");
        }
        this.synthesisEngine = synthesisEngine;
    }

    public UnitGenerator getTopUnit() {
        UnitGenerator unit = this;
        while (unit.circuit != null) {
            unit = unit.circuit;
        }
        LOGGER.debug("getTopUnit " + this + " => " + unit);
        return unit;
    }

    protected void autoStop() {
        this.synthesisEngine.autoStopUnit(this.getTopUnit());
    }

    public double convertHalfLifeToMultiplier(double halfLife) {
        if (halfLife < 2.0 * this.getFramePeriod()) {
            return 1.0;
        }
        return 1.0 - Math.pow(0.5, 1.0 / (halfLife * (double)this.getSynthesisEngine().getFrameRate()));
    }

    protected double incrementWrapPhase(double currentPhase, double phaseIncrement) {
        if ((currentPhase += phaseIncrement) >= 1.0) {
            currentPhase -= 2.0;
        } else if (currentPhase < -1.0) {
            currentPhase += 2.0;
        }
        return currentPhase;
    }

    protected double convertTimeToRate(double time) {
        double period2X = this.synthesisEngine.getInverseNyquist();
        if (time < period2X) {
            return 1.0;
        }
        return this.getFramePeriod() / time;
    }

    public void flattenOutputs() {
        for (UnitPort port : this.ports.values()) {
            if (!(port instanceof UnitOutputPort)) continue;
            ((UnitOutputPort)port).flatten();
        }
    }

    public void setCircuit(Circuit circuit) {
        if (this.circuit != null && circuit != null) {
            throw new RuntimeException("Unit is already in a circuit.");
        }
        this.circuit = circuit;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public void pullData(long frameCount, int start, int limit) {
        if (this.enabled && frameCount > this.lastFrameCount) {
            this.lastFrameCount = frameCount;
            for (UnitPort port : this.ports.values()) {
                if (!(port instanceof ConnectableInput)) continue;
                ((ConnectableInput)((Object)port)).pullData(frameCount, start, limit);
            }
            this.generate(start, limit);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.flattenOutputs();
        }
    }

    public boolean isStartRequired() {
        return false;
    }

    public void start() {
        if (this.getSynthesisEngine() == null) {
            throw new RuntimeException("This " + this.getClass().getName() + " was not add()ed to a Synthesizer.");
        }
        this.getSynthesisEngine().startUnit(this);
    }

    public void start(double time) {
        this.start(new TimeStamp(time));
    }

    public void start(TimeStamp timeStamp) {
        if (this.getSynthesisEngine() == null) {
            throw new RuntimeException("This " + this.getClass().getName() + " was not add()ed to a Synthesizer.");
        }
        this.getSynthesisEngine().startUnit(this, timeStamp);
    }

    public void stop(double time) {
        this.stop(new TimeStamp(time));
    }

    public void stop() {
        this.getSynthesisEngine().stopUnit(this);
    }

    public void stop(TimeStamp timeStamp) {
        this.getSynthesisEngine().stopUnit(this, timeStamp);
    }

    @Deprecated
    public void setFrameRate(int rate) {
    }

    public UnitGenerator getUnitGenerator() {
        return this;
    }

    public void setPort(String portName, double value, TimeStamp timeStamp) {
        UnitInputPort port = (UnitInputPort)this.getPortByName(portName);
        if (port == null) {
            LOGGER.warn("port was null for name " + portName + ", " + this.getClass().getName());
        } else {
            port.set(value, timeStamp);
        }
    }

    public void printConnections() {
        this.printConnections(System.out);
    }

    public void printConnections(PrintStream out) {
        this.printConnections(out, 0);
    }

    public void printConnections(PrintStream out, int level) {
        for (UnitPort port : this.getPorts()) {
            if (!(port instanceof UnitInputPort)) continue;
            ((UnitInputPort)port).printConnections(out, level);
        }
    }
}

