/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.unitgen.UnitOscillator;

public class ImpulseOscillator
extends UnitOscillator {
    @Override
    public void generate(int start, int limit) {
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        double currentPhase = this.phase.getValue();
        double inverseNyquist = this.synthesisEngine.getInverseNyquist();
        int i = start;
        while (i < limit) {
            double phaseIncrement = frequencies[i] * inverseNyquist;
            currentPhase += phaseIncrement;
            double ampl = amplitudes[i];
            double result = 0.0;
            if (currentPhase >= 1.0) {
                currentPhase -= 2.0;
                result = ampl;
            } else if (currentPhase < -1.0) {
                currentPhase += 2.0;
                result = ampl;
            }
            outputs[i] = result;
            ++i;
        }
        this.phase.setValue(currentPhase);
    }
}

