/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.devices.AudioDeviceFactory;
import com.jsyn.ports.QueueDataCommand;
import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.DoubleBoundedRangeSlider;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.unitgen.VariableRateStereoReader;
import com.jsyn.util.SampleLoader;
import java.awt.GridLayout;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PlaySampleCrossfade
extends JApplet {
    private static final double LOOP_START_FRACTION = 0.2;
    private Synthesizer synth;
    private VariableRateDataReader samplePlayer;
    private LineOut lineOut;
    private FloatSample sample;
    private DoubleBoundedRangeModel rangeModelSize;
    private DoubleBoundedRangeModel rangeModelCrossfade;
    private int loopStartFrame;

    @Override
    public void init() {
        URL sampleFile;
        try {
            sampleFile = new URL("http://www.softsynth.com/samples/Clarinet.wav");
        }
        catch (MalformedURLException e2) {
            e2.printStackTrace();
            return;
        }
        this.synth = JSyn.createSynthesizer(AudioDeviceFactory.createAudioDeviceManager(true));
        try {
            this.lineOut = new LineOut();
            this.synth.add(this.lineOut);
            SampleLoader.setJavaSoundPreferred(false);
            this.sample = SampleLoader.loadFloatSample(sampleFile);
            if (this.sample.getChannelsPerFrame() == 1) {
                this.samplePlayer = new VariableRateMonoReader();
                this.synth.add(this.samplePlayer);
                this.samplePlayer.output.connect(0, this.lineOut.input, 0);
            } else if (this.sample.getChannelsPerFrame() == 2) {
                this.samplePlayer = new VariableRateStereoReader();
                this.synth.add(this.samplePlayer);
                this.samplePlayer.output.connect(0, this.lineOut.input, 0);
                this.samplePlayer.output.connect(1, this.lineOut.input, 1);
            } else {
                throw new RuntimeException("Can only play mono or stereo samples.");
            }
            this.samplePlayer.rate.set(this.sample.getFrameRate());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.loopStartFrame = (int)((double)this.sample.getNumFrames() * 0.2);
        this.setLayout(new GridLayout(0, 1));
        this.samplePlayer.rate.setup(4000.0, this.sample.getFrameRate(), this.sample.getFrameRate() * 2.0);
        this.add(PortControllerFactory.createExponentialPortSlider(this.samplePlayer.rate));
        this.rangeModelSize = new DoubleBoundedRangeModel("LoopSize (fraction)", 10000, 0.01, 0.8, 0.5);
        this.rangeModelSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlaySampleCrossfade.this.queueNewLoop();
            }
        });
        this.add(new DoubleBoundedRangeSlider(this.rangeModelSize, 3));
        this.rangeModelCrossfade = new DoubleBoundedRangeModel("Crossfade (samples)", 1000, 0.0, 1000.0, 0.0);
        this.rangeModelCrossfade.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PlaySampleCrossfade.this.queueNewLoop();
            }
        });
        this.add(new DoubleBoundedRangeSlider(this.rangeModelCrossfade, 3));
        this.validate();
    }

    private void queueNewLoop() {
        int loopSize = (int)((double)this.sample.getNumFrames() * this.rangeModelSize.getDoubleValue());
        if (this.loopStartFrame + loopSize > this.sample.getNumFrames()) {
            loopSize = this.sample.getNumFrames() - this.loopStartFrame;
        }
        int crossFadeSize = (int)this.rangeModelCrossfade.getDoubleValue();
        QueueDataCommand command = this.samplePlayer.dataQueue.createQueueDataCommand(this.sample, this.loopStartFrame, loopSize);
        command.setNumLoops(-1);
        command.setSkipIfOthers(true);
        command.setCrossFadeIn(crossFadeSize);
        this.synth.queueCommand(command);
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
        this.samplePlayer.dataQueue.queue(this.sample, 0, this.loopStartFrame);
        this.queueNewLoop();
    }

    @Override
    public void stop() {
        this.synth.stop();
        this.synth.stop();
    }

    public static void main(String[] args) {
        PlaySampleCrossfade applet = new PlaySampleCrossfade();
        JAppletFrame frame = new JAppletFrame("PlaySampleCrossfade", applet);
        frame.setSize(440, 300);
        frame.setVisible(true);
        frame.test();
    }
}

