/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitOscillator;

public class GoogleWaveOscillator
extends UnitOscillator {
    public UnitInputPort variance = new UnitInputPort("Variance", 0.0);
    private double phaseIncrement = 0.1;
    private double previousY;
    private double randomAmplitude = 0.0;

    public GoogleWaveOscillator() {
        this.addPort(this.variance);
    }

    @Override
    public void generate(int start, int limit) {
        double[] freqs = this.frequency.getValues();
        double[] outputs = this.output.getValues();
        double currentPhase = this.phase.getValue();
        int i = start;
        while (i < limit) {
            double y;
            if (currentPhase > 0.0) {
                y = Math.sqrt(4.0 * (currentPhase * (1.0 - currentPhase)));
            } else {
                double p = -currentPhase;
                y = -Math.sqrt(4.0 * (p * (1.0 - p)));
            }
            if (this.previousY * y <= 0.0) {
                double v = this.variance.getValues()[0];
                double range = (Math.random() - 0.5) * 4.0 * v;
                double scale = Math.pow(2.0, range);
                this.phaseIncrement = this.convertFrequencyToPhaseIncrement(freqs[i]) * scale;
                scale = 1.0 + (Math.random() - 0.5) * 1.5 * v;
                this.randomAmplitude = this.amplitude.getValues()[0] * scale;
            }
            outputs[i] = y * this.randomAmplitude;
            this.previousY = y;
            currentPhase = this.incrementWrapPhase(currentPhase, this.phaseIncrement);
            ++i;
        }
        this.phase.setValue(currentPhase);
    }
}

