/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.swing.EnvelopeEditorPanel;
import com.jsyn.swing.EnvelopePoints;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EditEnvelope1
extends JApplet {
    private Synthesizer synth;
    private UnitOscillator osc;
    private LineOut lineOut;
    private SegmentedEnvelope envelope;
    private VariableRateDataReader envelopePlayer;
    final int MAX_FRAMES = 16;
    JButton hitme;
    JButton attackButton;
    JButton releaseButton;
    private EnvelopeEditorPanel envEditor;
    private EnvelopePoints points;

    public static void main(String[] args) {
        EditEnvelope1 applet = new EditEnvelope1();
        JAppletFrame frame = new JAppletFrame("Test SynthEnvelope", applet);
        frame.setSize(440, 200);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.envelopePlayer = new VariableRateMonoReader();
        this.synth.add(this.envelopePlayer);
        this.envelope = new SegmentedEnvelope(16);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.envelopePlayer.output.connect(this.osc.amplitude);
        this.osc.output.connect(0, this.lineOut.input, 0);
        this.osc.output.connect(0, this.lineOut.input, 1);
        this.synth.start();
        JPanel bottomPanel = new JPanel();
        this.hitme = new JButton("On");
        bottomPanel.add(this.hitme);
        this.hitme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditEnvelope1.this.points.updateEnvelopeIfDirty(EditEnvelope1.this.envelope);
                ((EditEnvelope1)EditEnvelope1.this).envelopePlayer.dataQueue.queueOn(EditEnvelope1.this.envelope);
            }
        });
        this.attackButton = new JButton("Off");
        bottomPanel.add(this.attackButton);
        this.attackButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditEnvelope1.this.points.updateEnvelopeIfDirty(EditEnvelope1.this.envelope);
                ((EditEnvelope1)EditEnvelope1.this).envelopePlayer.dataQueue.queueOff(EditEnvelope1.this.envelope);
            }
        });
        this.releaseButton = new JButton("Queue");
        bottomPanel.add(this.releaseButton);
        this.releaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditEnvelope1.this.points.updateEnvelopeIfDirty(EditEnvelope1.this.envelope);
                ((EditEnvelope1)EditEnvelope1.this).envelopePlayer.dataQueue.queue(EditEnvelope1.this.envelope);
            }
        });
        this.add((Component)bottomPanel, "South");
        this.lineOut.start();
        this.points = new EnvelopePoints();
        this.points.setName(this.osc.amplitude.getName());
        this.points.add(0.5, 1.0);
        this.points.add(0.5, 0.2);
        this.points.add(0.5, 0.8);
        this.points.add(0.5, 0.0);
        this.points.updateEnvelope(this.envelope);
        this.envEditor = new EnvelopeEditorPanel(this.points, 16);
        this.add("Center", this.envEditor);
        this.getParent().validate();
        this.getToolkit().sync();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }
}

