/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.javasound;

import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidiDeviceTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(MidiDeviceTools.class);

    public static void listDevices() {
        MidiDevice.Info[] infos;
        MidiDevice.Info[] infoArray = infos = MidiSystem.getMidiDeviceInfo();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            MidiDevice.Info info = infoArray[n2];
            LOGGER.debug("MIDI Info: " + info.getDescription() + ", " + info.getName() + ", " + info.getVendor() + ", " + info.getVersion());
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                LOGGER.debug("   Device: , #recv = " + device.getMaxReceivers() + ", #xmit = " + device.getMaxTransmitters() + ", open = " + device.isOpen() + ", " + device);
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static MidiDevice findKeyboard(String text) {
        MidiDevice.Info[] infos;
        MidiDevice keyboard = null;
        MidiDevice.Info[] infoArray = infos = MidiSystem.getMidiDeviceInfo();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            MidiDevice.Info info = infoArray[n2];
            try {
                MidiDevice device = MidiSystem.getMidiDevice(info);
                if (!(device instanceof Synthesizer || device instanceof Sequencer || device.getMaxTransmitters() == 0 || text != null && !info.getDescription().toLowerCase().contains(text.toLowerCase()))) {
                    keyboard = device;
                    LOGGER.debug("Chose: " + info.getDescription());
                    break;
                }
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return keyboard;
    }

    public static MidiDevice findKeyboard() {
        return MidiDeviceTools.findKeyboard(null);
    }
}

