/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.demo;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.SubtractiveSynthVoice;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.compose.swing.BasicScoreInstrument;
import com.softsynth.score.JSynScoreClock;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreInstrument;
import com.softsynth.score.ScorePlayer;
import javax.swing.JApplet;

public class DynaTonic
extends JApplet {
    private static final int MAX_VOICES = 8;
    private Synthesizer synth;
    private VoiceAllocator allocator;
    private LineOut lineOut;
    private double advance = 0.2;
    private ScoreInstrument instrument;
    String scoreText = "[ { 1/1 2/1 } { 1/1 4/1 } ]";
    private ScorePlayer scorePlayer;
    private SubtractiveSynthVoice[] voices;
    private ScoreClock clock;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.voices = new SubtractiveSynthVoice[8];
        int i = 0;
        while (i < 8) {
            SubtractiveSynthVoice voice = new SubtractiveSynthVoice();
            this.synth.add(voice);
            voice.getOutput().connect(0, this.lineOut.input, 0);
            voice.getOutput().connect(0, this.lineOut.input, 1);
            this.voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(this.voices);
        this.clock = new JSynScoreClock(this.synth);
        this.instrument = new BasicScoreInstrument(this.clock, this.allocator);
        this.scorePlayer = new ScorePlayer((ScoreClock)((Object)this.synth));
        this.scorePlayer.setAdvance(this.advance);
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
        double timeNow = this.clock.getScoreTime();
        double time = timeNow + 1.0;
        try {
            time = this.scorePlayer.playScoreText(this.scoreText, this.instrument, time);
            this.synth.sleepUntil(time + 2.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] args) {
        DynaTonic applet = new DynaTonic();
        applet.init();
        applet.start();
        applet.stop();
    }
}

