/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;
import org.w3c.dom.Element;

public class InputBitMaskJack
extends InputJack {
    private int columnCount = 32;
    private long value = 0L;

    public InputBitMaskJack(SyntonaModule module, String name) {
        this(module, name, "");
    }

    public InputBitMaskJack(SyntonaModule module, String name, String help) {
        super(module, name, help);
        this.setViewType(3);
    }

    @Override
    public void loadContents(Element jackElement) {
        this.setColumnCount(XMLDOMLoader.parseIntegerAttribute(jackElement, "columns"));
        this.setValue(XMLDOMLoader.parseLongAttribute(jackElement, "value"));
    }

    @Override
    public void save(SyntonaSaver saver) {
        saver.beginElement("jack");
        saver.addAttribute("name", this.name);
        saver.addAttribute("columns", "" + this.columnCount);
        saver.addAttribute("value", "" + this.value);
        saver.endElement();
    }

    @Override
    public void passMessage(PatchMessage msg) {
        super.passMessage(msg);
    }

    @Override
    public boolean willAccept(Jack other) {
        return false;
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long d) {
        this.value = d;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    @Override
    public String getValueText() {
        return "" + this.getValue();
    }

    @Override
    public JackEditor getEditor(ModulePresenter modulePresenter) {
        return null;
    }
}

