/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.midi;

import com.jsyn.devices.javasound.MidiDeviceTools;
import com.jsyn.midi.MessageParser;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

public class MidiEngine {
    private static MidiEngine instance;
    private CopyOnWriteArrayList<NoteReceiver> mNoteOnReceivers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<NoteReceiver> mNoteOffReceivers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ControlChangeReceiver> mControlChangeReceivers = new CopyOnWriteArrayList();
    private EngineParser mParser = new EngineParser();
    private Receiver mReceiver = new EngineReceiver();
    private MidiDevice mKeyboard;
    private Transmitter mTransmitter;

    public static MidiEngine getInstance() {
        if (instance == null) {
            instance = new MidiEngine();
        }
        return instance;
    }

    private MidiEngine() {
    }

    Transmitter getTransmitter() throws MidiUnavailableException {
        Transmitter transmitter;
        block2: {
            transmitter = null;
            try {
                transmitter = MidiSystem.getTransmitter();
                System.out.println("Default MIDI transmitter found.");
            }
            catch (MidiUnavailableException e) {
                System.out.println("Default MIDI transmitter not specified.");
                this.mKeyboard = MidiDeviceTools.findKeyboard();
                if (this.mKeyboard == null) break block2;
                System.out.println("Found MIDI keyboard: " + this.mKeyboard.getDeviceInfo().getDescription());
                this.mKeyboard.open();
                transmitter = this.mKeyboard.getTransmitter();
            }
        }
        return transmitter;
    }

    public void start() {
        try {
            this.mTransmitter = this.getTransmitter();
            if (this.mTransmitter != null) {
                this.mTransmitter.setReceiver(this.mReceiver);
            } else {
                System.out.println("Could not find a transmitter, eg. a keyboard.");
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.mTransmitter != null) {
            this.mTransmitter.close();
            System.out.println("Closed MIDI transmitter.");
            this.mTransmitter = null;
        }
        if (this.mKeyboard != null) {
            this.mKeyboard.close();
            System.out.println("Closed MIDI keyboard.");
            this.mKeyboard = null;
        }
    }

    public void reset() {
        this.stop();
        this.start();
    }

    public void addNoteOnReceiver(NoteReceiver receiver) {
        this.mNoteOnReceivers.add(receiver);
    }

    public void addNoteOffReceiver(NoteReceiver receiver) {
        this.mNoteOffReceivers.add(receiver);
    }

    public void addControlChangeReceiver(ControlChangeReceiver receiver) {
        this.mControlChangeReceivers.add(receiver);
    }

    public static interface ControlChangeReceiver {
        public void onControlChange(int var1, int var2, int var3);
    }

    private class EngineParser
    extends MessageParser {
        private EngineParser() {
        }

        @Override
        public void noteOn(int channel, int pitch, int velocity) {
            for (NoteReceiver receiver : MidiEngine.this.mNoteOnReceivers) {
                receiver.onNote(channel, pitch, velocity);
            }
        }

        @Override
        public void noteOff(int channel, int pitch, int velocity) {
            for (NoteReceiver receiver : MidiEngine.this.mNoteOffReceivers) {
                receiver.onNote(channel, pitch, velocity);
            }
        }

        @Override
        public void controlChange(int channel, int index, int value) {
            for (ControlChangeReceiver receiver : MidiEngine.this.mControlChangeReceivers) {
                receiver.onControlChange(channel, index, value);
            }
        }
    }

    private class EngineReceiver
    implements Receiver {
        private EngineReceiver() {
        }

        @Override
        public void send(MidiMessage message, long timeStamp) {
            byte[] bytes = message.getMessage();
            MidiEngine.this.mParser.parse(bytes);
        }

        @Override
        public void close() {
        }
    }

    public static interface NoteReceiver {
        public void onNote(int var1, int var2, int var3);
    }
}

