/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.gui.AlertUser;
import com.syntona.model.SyntonaSaver;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchListener;
import com.syntona.plugin.SyntonaModule;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PatchModule
extends SyntonaModule {
    private final CopyOnWriteArrayList<SyntonaModule> modules = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PatchListener> listeners = new CopyOnWriteArrayList();

    public PatchModule() {
        this.setHelp("Contains other modules.");
    }

    public void firePatchChanged() {
        for (PatchListener patchListener : this.listeners) {
            patchListener.patchChanged(this);
        }
    }

    public void addPatchListener(PatchListener patchListener) {
        this.listeners.add(patchListener);
    }

    public void removePatchListener(PatchListener patchListener) {
        this.listeners.remove(patchListener);
    }

    public void remove(SyntonaModule module) {
        module.disconnectAllJacks();
        this.modules.remove(module);
        this.firePatchChanged();
    }

    public void add(SyntonaModule addedModule) {
        this.modules.add(addedModule);
        this.firePatchChanged();
    }

    @Override
    public void shutdown() {
        for (SyntonaModule module : this.modules) {
            module.shutdown();
        }
    }

    public SyntonaModule[] getModules() {
        return this.modules.toArray(new SyntonaModule[0]);
    }

    public void saveConnections(SyntonaSaver saver) {
        this.saveConnections(saver, this.modules, false);
    }

    public void saveConnections(SyntonaSaver saver, List<SyntonaModule> selectedModules, boolean saveExternalConnections) {
        saver.beginElement("connections");
        for (SyntonaModule module : selectedModules) {
            Jack[] jacks;
            Jack[] jackArray = jacks = module.getJacks();
            int n = jacks.length;
            int n2 = 0;
            while (n2 < n) {
                SyntonaModule otherModule;
                Jack otherJack;
                Iterator<Jack> connected;
                Jack jack = jackArray[n2];
                if (jack instanceof OutputJack) {
                    OutputJack outJack = (OutputJack)jack;
                    saver.beginElement("output");
                    saver.addAttribute("id", "" + module.getSaveId());
                    saver.addAttribute("jack", outJack.getName());
                    connected = jack.getConnected();
                    while (connected.hasNext()) {
                        otherJack = connected.next();
                        otherModule = otherJack.getModule();
                        if (selectedModules.contains(otherModule)) {
                            saver.beginElement("input");
                            saver.addAttribute("id", "" + otherModule.getSaveId());
                            saver.addAttribute("jack", otherJack.getName());
                            saver.endElement();
                            continue;
                        }
                        if (!saveExternalConnections) continue;
                        saver.beginElement("input");
                        saver.addAttribute("module", otherModule.getName());
                        saver.addAttribute("jack", otherJack.getName());
                        saver.endElement();
                    }
                    saver.endElement();
                } else if (jack instanceof InputJack && saveExternalConnections) {
                    InputJack inJack = (InputJack)jack;
                    connected = jack.getConnected();
                    while (connected.hasNext()) {
                        otherJack = connected.next();
                        otherModule = otherJack.getModule();
                        if (selectedModules.contains(otherModule)) continue;
                        saver.beginElement("output");
                        saver.addAttribute("module", otherModule.getName());
                        saver.addAttribute("jack", otherJack.getName());
                        saver.beginElement("input");
                        saver.addAttribute("id", "" + module.getSaveId());
                        saver.addAttribute("jack", inJack.getName());
                        saver.endElement();
                        saver.endElement();
                    }
                }
                ++n2;
            }
        }
        saver.endElement();
    }

    public int size() {
        return this.modules.size();
    }

    public void clear() {
        for (SyntonaModule module : this.modules) {
            module.disconnectAllJacks();
        }
        this.modules.clear();
        this.firePatchChanged();
    }

    @Override
    public boolean validateExport() {
        AlertUser.showError("Plain patches cannot be exported. Only export JSyn voices.");
        return false;
    }

    public SyntonaModule findModuleByName(String name) {
        for (SyntonaModule module : this.modules) {
            if (!name.equals(module.getName())) continue;
            return module;
        }
        return null;
    }
}

