/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.core;

import com.syntona.model.SyntonaCommand;
import com.syntona.plugin.InputActionJack;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.SyntonaModule;
import com.syntona.plugin.WireTime;

public class ClockModule
extends SyntonaModule {
    private int counter;
    private InputDoubleJack period;
    private OutputDoubleJack output;
    private boolean running;
    private double mMinimumPeriod = 0.1;

    public ClockModule() {
        super("Send periodic message, increment by 1.");
        new InputActionJack(this, "reset", "reset counter back to zero"){

            @Override
            public void execute() {
                ClockModule.this.counter = 0;
            }
        };
        new InputActionJack(this, "start", "start clock running if not already running"){

            @Override
            public void execute() {
                if (!ClockModule.this.running) {
                    ClockModule.this.running = true;
                    ClockModule.this.scheduleNextTick(new WireTime());
                }
            }
        };
        new InputActionJack(this, "stop", "stop clock"){

            @Override
            public void execute() {
                ClockModule.this.running = false;
            }
        };
        this.period = new InputDoubleJack(this, "period");
        this.period.setValue(0.25);
        this.period.setMin(this.mMinimumPeriod);
        this.output = new OutputDoubleJack(this, "out");
    }

    public void scheduleNextTick(WireTime time) {
        ClockCommand cmd = new ClockCommand();
        this.getEngine().send(time, cmd);
    }

    class ClockCommand
    implements SyntonaCommand {
        ClockCommand() {
        }

        @Override
        public void execute() {
            if (ClockModule.this.running) {
                ClockModule clockModule = ClockModule.this;
                int n = clockModule.counter;
                clockModule.counter = n + 1;
                ClockModule.this.passDoubleMessage(n, ClockModule.this.output);
                double sleepTime = Math.max(ClockModule.this.mMinimumPeriod, ClockModule.this.period.getValue());
                WireTime future = ClockModule.this.getEngine().getEngineTime().makeRelative(sleepTime);
                ClockModule.this.scheduleNextTick(future);
            }
        }

        @Override
        public void undo() {
        }
    }
}

