/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JPanel;

public class BooleanBox
extends JPanel {
    private boolean mSelected;
    private boolean mCurrent;
    private CopyOnWriteArrayList<ActionListener> mActionListeners = new CopyOnWriteArrayList();
    private static final int WIDTH = 20;
    private static final int HEIGHT = 20;
    private static final int MARGIN = 4;

    public BooleanBox() {
        this.addMouseListener(new MyMouseListener());
        Dimension dim = new Dimension(20, 20);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    @Override
    public void paintComponent(Graphics g) {
        int diameter;
        super.paintComponent(g);
        Color backColor = this.mCurrent ? Color.ORANGE : this.getBackground();
        g.setColor(backColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int x = 2;
        int y = 2;
        int w = this.getWidth() - 4;
        int h = this.getHeight() - 4;
        int n = diameter = w < h ? w : h;
        if (this.mSelected) {
            g.setColor(Color.CYAN);
            g.fillOval(x, y, diameter, diameter);
        }
        g.setColor(Color.BLACK);
        g.drawOval(x, y, diameter, diameter);
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public boolean isCurrent() {
        return this.mCurrent;
    }

    public void setCurrent(boolean current) {
        this.mCurrent = current;
    }

    public void setSelected(boolean selected) {
        this.mSelected = selected;
        this.repaint();
    }

    public void fireActionListeners() {
        ActionEvent event = new ActionEvent(this, 1001, "toggle");
        for (ActionListener actionListener : this.mActionListeners) {
            actionListener.actionPerformed(event);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.mActionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.mActionListeners.remove(actionListener);
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BooleanBox.this.setSelected(!BooleanBox.this.isSelected());
            BooleanBox.this.fireActionListeners();
        }
    }
}

