/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.BooleanBox;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.plugin.InputBitMaskJack;
import com.syntona.plugin.SyntonaModel;
import com.syntona.plugin.SyntonaModelListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class BitMaskJackView
extends JPanel {
    private InputBitMaskJack mJack;
    private BooleanBox[] mBoxes;

    public BitMaskJackView(InputBitMaskJack jack) {
        this.mJack = jack;
        BoxLayout layout = new BoxLayout(this, 0);
        this.setLayout(layout);
        long value = jack.getValue();
        int numColumns = 16;
        this.mBoxes = new BooleanBox[numColumns];
        int i = 0;
        while (i < numColumns) {
            final BooleanBox checkbox = new BooleanBox();
            final long mask = 1 << i;
            checkbox.setSelected((value & mask) != 0L);
            checkbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long bits = BitMaskJackView.this.mJack.getValue();
                    bits = checkbox.isSelected() ? (bits |= mask) : (bits &= mask ^ 0xFFFFFFFFFFFFFFFFL);
                    BitMaskJackView.this.mJack.setValue(bits);
                }
            });
            this.add(checkbox);
            this.mBoxes[i] = checkbox;
            ++i;
        }
        this.mJack.addModelListener(new SyntonaModelListener(){
            int previousIndex = 0;

            @Override
            public void nameChanged(SyntonaModel syntonaModel) {
            }

            @Override
            public void onOffChanged(SyntonaModel syntonaModel, boolean onOrOff) {
            }

            @Override
            public void indexChanged(SyntonaModel syntonaModel, int index) {
                BitMaskJackView.this.mBoxes[this.previousIndex].setCurrent(false);
                BitMaskJackView.this.mBoxes[index].setCurrent(true);
                if (PatchFrame.isOnTop(BitMaskJackView.this)) {
                    if (BitMaskJackView.this.mBoxes[this.previousIndex].isVisible()) {
                        BitMaskJackView.this.mBoxes[this.previousIndex].repaint();
                    }
                    if (BitMaskJackView.this.mBoxes[index].isVisible()) {
                        BitMaskJackView.this.mBoxes[index].repaint();
                    }
                }
                this.previousIndex = index;
            }
        });
    }
}

