/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.keyboard;

import com.syntona.gui.keyboard.MusicKeyboardEvent;
import com.syntona.gui.keyboard.MusicKeyboardListener;
import com.syntona.gui.keyboard.MusicKeyboardModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComponent;

public class MusicKeyboardController
extends JComponent
implements MouseListener,
MouseMotionListener,
Observer {
    private int lowPitch;
    private int highPitch;
    private int numPitches;
    private double BLACK_KEY_SPAN = 0.7;
    private MusicKeyboardModel model;
    private static final int INVALID_PITCH = -1;
    private int lastPitch = -1;
    private Vector<MusicKeyboardListener> listeners;
    private boolean[] blackNotes;
    private static int id = 0;

    public MusicKeyboardController() {
        this(0, 127);
    }

    public MusicKeyboardController(int low, int high) {
        boolean[] blArray = new boolean[12];
        blArray[1] = true;
        blArray[3] = true;
        blArray[6] = true;
        blArray[8] = true;
        blArray[10] = true;
        this.blackNotes = blArray;
        this.lowPitch = low;
        this.highPitch = high;
        this.numPitches = this.highPitch - this.lowPitch + 1;
        this.setPreferredSize(new Dimension(2000, 40));
        this.model = new MusicKeyboardModel();
        this.model.addObserver(this);
        this.listeners = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private boolean isBlack(int pitch) {
        int note = pitch % 12;
        return this.blackNotes[note];
    }

    private int getNumKeyPositions() {
        double numOctaves = (double)this.numPitches / 12.0;
        return (int)(numOctaves * 7.0) + 1;
    }

    public int pickPitch(int pX, int pY) {
        int pitch;
        int w = this.getWidth();
        int h = this.getHeight();
        int hb = 6 * h / 10;
        int numKeyPositions = this.getNumKeyPositions();
        int keyPosition = -1;
        double keySpacing = (double)w / (double)numKeyPositions;
        int xb1 = (int)(keySpacing * (1.0 - this.BLACK_KEY_SPAN * 0.5));
        int xb2 = (int)(keySpacing * (1.0 + this.BLACK_KEY_SPAN * 0.5));
        int i = 0;
        while (i < this.numPitches) {
            pitch = this.lowPitch + i;
            if (this.isBlack(pitch)) {
                int x = keyPosition * w / numKeyPositions;
                int x1 = x + xb1;
                int x2 = x + xb2;
                if (pX >= x1 && pX < x2 && pY < hb) {
                    return pitch;
                }
            } else {
                ++keyPosition;
            }
            ++i;
        }
        keyPosition = -1;
        i = 0;
        while (i < this.numPitches) {
            pitch = this.lowPitch + i;
            if (!this.isBlack(pitch)) {
                int x1 = ++keyPosition * w / numKeyPositions;
                int x2 = (keyPosition + 1) * w / numKeyPositions;
                if (pX >= x1 && pX < x2) {
                    return pitch;
                }
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void paint(Graphics g) {
        Color color;
        int pitch;
        int w = this.getWidth();
        int h = this.getHeight();
        int heightBlack = 6 * h / 10;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        int numKeyPositions = this.getNumKeyPositions();
        int keyPosition = -1;
        double keySpacing = (double)w / (double)numKeyPositions;
        int i = 0;
        while (i < this.numPitches) {
            pitch = this.lowPitch + i;
            if (!this.isBlack(pitch)) {
                color = this.model.getNoteVelocity(pitch) > 0 ? Color.YELLOW : Color.WHITE;
                g.setColor(color);
                int x1 = ++keyPosition * w / numKeyPositions;
                int x2 = (keyPosition + 1) * w / numKeyPositions;
                g.fillRect(x1 + 1, 0, x2 - x1, h);
                g.setColor(Color.BLACK);
                g.drawLine(x2, 0, x2, h);
                String text = Integer.toString(pitch);
                FontMetrics metrics = g.getFontMetrics();
                Rectangle2D textBounds = metrics.getStringBounds(text, g);
                int wt = (int)textBounds.getWidth();
                int ht = (int)textBounds.getHeight();
                int xt = (x1 + x2 - wt) / 2;
                int yt = (h + heightBlack + ht) / 2;
                g.drawString(text, xt, yt);
            }
            ++i;
        }
        keyPosition = -1;
        i = 0;
        while (i < this.numPitches) {
            pitch = this.lowPitch + i;
            if (this.isBlack(pitch)) {
                color = this.model.getNoteVelocity(pitch) > 0 ? Color.YELLOW.darker() : Color.BLACK;
                g.setColor(color);
                int x = keyPosition * w / numKeyPositions;
                int x1 = x + (int)(keySpacing * (1.0 - this.BLACK_KEY_SPAN * 0.5));
                int x2 = x + (int)(keySpacing * (1.0 + this.BLACK_KEY_SPAN * 0.5));
                g.fillRect(x1, 0, x2 - x1, heightBlack);
                String text = Integer.toString(pitch);
                g.setColor(Color.WHITE);
                FontMetrics metrics = g.getFontMetrics();
                Rectangle2D textBounds = metrics.getStringBounds(text, g);
                int wt = (int)textBounds.getWidth();
                int ht = (int)textBounds.getHeight();
                int xt = (x1 + x2 - wt) / 2;
                int yt = (heightBlack + ht) / 2;
                g.drawString(text, xt, yt);
            } else {
                ++keyPosition;
            }
            ++i;
        }
    }

    public void setNoteVelocity(int pitch, int velocity) {
        this.model.setNoteVelocity(pitch, velocity);
    }

    private void mouseNoteOn(int pitch) {
        if (pitch != -1) {
            this.setNoteVelocity(pitch, 64);
            this.fireMusicEvent(pitch, true);
        }
        this.lastPitch = pitch;
    }

    private void lastMouseNoteOff() {
        if (this.lastPitch != -1) {
            this.setNoteVelocity(this.lastPitch, 0);
            this.fireMusicEvent(this.lastPitch, false);
        }
        this.lastPitch = -1;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lastMouseNoteOff();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int pitch = this.pickPitch(e.getX(), e.getY());
        if (pitch != this.lastPitch) {
            this.lastMouseNoteOff();
            this.mouseNoteOn(pitch);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int pitch = this.pickPitch(e.getX(), e.getY());
        this.mouseNoteOn(pitch);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isShiftDown()) {
            this.lastMouseNoteOff();
        }
    }

    public void addMusicKeyboardListener(MusicKeyboardListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeMusicKeyboardListener(MusicKeyboardListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireMusicEvent(int pitch, boolean onOrOff) {
        Enumeration<MusicKeyboardListener> lers = this.listeners.elements();
        MusicKeyboardEvent event = new MusicKeyboardEvent(this, id++, onOrOff ? "on" : "off", 0L, 0, pitch);
        while (lers.hasMoreElements()) {
            MusicKeyboardListener listener = lers.nextElement();
            listener.musicHappened(event);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.model) {
            this.repaint();
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.width / 2;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getWidth() / this.getNumKeyPositions();
    }
}

