/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.EnvelopeAttackDecay;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.TestUnitGate;

public class TestEnvelopeAttackDecay
extends TestUnitGate {
    double attackTime;
    double decayTime;

    protected void setUp() throws Exception {
        super.setUp();
        this.synthesisEngine = new SynthesisEngine();
        this.synthesisEngine.setRealTime(false);
        this.attackTime = 0.2;
        this.decayTime = 0.4;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.synthesisEngine.stop();
    }

    public void testOnOff() throws InterruptedException {
        EnvelopeAttackDecay envelope = new EnvelopeAttackDecay();
        this.synthesisEngine.add(envelope);
        envelope.attack.set(0.1);
        envelope.decay.set(0.2);
        this.synthesisEngine.start();
        envelope.start();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.1);
        TestEnvelopeAttackDecay.assertEquals((String)"still idling", (Object)0.0, (Object)envelope.output.getValue());
        envelope.input.on();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.1);
        TestEnvelopeAttackDecay.assertTrue((String)"at peak", (envelope.output.getValue() > 0.8 ? 1 : 0) != 0);
        envelope.input.off();
        this.synthesisEngine.sleepUntil(this.time + 0.3);
        TestEnvelopeAttackDecay.assertTrue((String)"at peak", (envelope.output.getValue() < 0.1 ? 1 : 0) != 0);
        this.synthesisEngine.sleepFor(0.1);
        envelope.input.trigger();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.1);
        TestEnvelopeAttackDecay.assertTrue((String)"at peak", (envelope.output.getValue() > 0.8 ? 1 : 0) != 0);
        this.synthesisEngine.sleepUntil(this.time + 0.3);
        TestEnvelopeAttackDecay.assertTrue((String)"at peak", (envelope.output.getValue() < 0.1 ? 1 : 0) != 0);
    }

    public void testRetrigger() throws InterruptedException {
        EnvelopeAttackDecay envelope = new EnvelopeAttackDecay();
        this.synthesisEngine.add(envelope);
        envelope.attack.set(0.1);
        envelope.decay.set(0.2);
        this.synthesisEngine.start();
        envelope.start();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.1);
        TestEnvelopeAttackDecay.assertEquals((String)"still idling", (Object)0.0, (Object)envelope.output.getValue());
        envelope.input.trigger();
        this.synthesisEngine.sleepFor(0.1);
        TestEnvelopeAttackDecay.assertEquals((String)"at peak", (double)1.0, (double)envelope.output.getValue(), (double)0.1);
        this.synthesisEngine.sleepFor(0.1);
        TestEnvelopeAttackDecay.assertTrue((String)"at peak", (envelope.output.getValue() < 0.7 ? 1 : 0) != 0);
        envelope.input.trigger();
        this.synthesisEngine.sleepFor(0.1);
        TestEnvelopeAttackDecay.assertEquals((String)"at peak", (double)1.0, (double)envelope.output.getValue(), (double)0.1);
        this.synthesisEngine.sleepFor(0.2);
        TestEnvelopeAttackDecay.assertTrue((String)"at peak", (envelope.output.getValue() < 0.1 ? 1 : 0) != 0);
    }

    public void testAutoDisable() throws InterruptedException {
        LinearRamp ramp = new LinearRamp();
        this.synthesisEngine.add(ramp);
        EnvelopeAttackDecay envelope = new EnvelopeAttackDecay();
        envelope.attack.set(0.1);
        envelope.decay.set(0.1);
        this.synthesisEngine.add(envelope);
        ramp.output.connect(envelope.amplitude);
        this.checkAutoDisable(ramp, envelope);
    }
}

