/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.data.Function;
import com.jsyn.ports.UnitFunctionPort;
import com.jsyn.unitgen.UnitOscillator;

public class FunctionOscillator
extends UnitOscillator {
    public UnitFunctionPort function = new UnitFunctionPort("Function");

    public FunctionOscillator() {
        this.addPort(this.function);
    }

    @Override
    public void generate(int start, int limit) {
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        Function functionObject = this.function.get();
        double currentPhase = this.phase.getValue();
        int i = start;
        while (i < limit) {
            double phaseIncrement = this.convertFrequencyToPhaseIncrement(frequencies[i]);
            currentPhase = this.incrementWrapPhase(currentPhase, phaseIncrement);
            double value = functionObject.evaluate(currentPhase);
            outputs[i] = value * amplitudes[i];
            ++i;
        }
        this.phase.setValue(currentPhase);
    }
}

