/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.FloatSample;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.DoubleBoundedRangeModel;
import com.jsyn.swing.ExponentialRangeModel;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortModelFactory;
import com.jsyn.swing.RotaryTextController;
import com.jsyn.unitgen.ContinuousRamp;
import com.jsyn.unitgen.GrainFarm;
import com.jsyn.unitgen.LineOut;
import com.jsyn.util.WaveRecorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlayGrains
extends JApplet {
    private static final long serialVersionUID = -8315903842197137926L;
    private Synthesizer synth;
    private LineOut lineOut;
    private AudioScope scope;
    private GrainFarm grainFarm;
    private ContinuousRamp ramp;
    private static final int NUM_GRAINS = 32;
    private FloatSample sample;
    private WaveRecorder recorder;
    private static final boolean useRecorder = false;
    private static final boolean useSample = false;
    private File sampleFile = new File("/Users/phil/Music/samples/ChewyMonkeysWhistle.aiff");

    public static void main(String[] args) {
        PlayGrains applet = new PlayGrains();
        JAppletFrame frame = new JAppletFrame("PlayGrains", applet);
        frame.setSize(840, 500);
        frame.setVisible(true);
        frame.test();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add("North", new JLabel("PlayGrains in an AudioScope - JSyn V" + this.synth.getVersion()));
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.grainFarm.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setControlsVisible(true);
        this.add("Center", this.scope.getView());
        this.scope.start();
        JPanel knobPanel = new JPanel();
        knobPanel.setLayout(new GridLayout(1, 0));
        knobPanel.add(this.setupPortKnob(this.grainFarm.density, 1.0, "Density"));
        knobPanel.add(this.setupPortKnob(this.grainFarm.rate, 4.0, "Rate"));
        knobPanel.add(this.setupPortKnob(this.grainFarm.rateRange, 3.0, "RateRange"));
        knobPanel.add(this.setupPortKnob(this.grainFarm.duration, 0.1, "Duration"));
        knobPanel.add(this.setupPortKnob(this.grainFarm.durationRange, 3.0, "DurRange"));
        knobPanel.add(this.setupPortKnob(this.grainFarm.amplitude, 6.0, "Amplitude"));
        knobPanel.add(this.setupPortKnob(this.grainFarm.amplitudeRange, 1.0, "AmpRange"));
        this.add((Component)knobPanel, "South");
        this.validate();
    }

    private RotaryTextController setupLinearPortKnob(UnitInputPort port, double min, double max, String label) {
        port.setMinimum(min);
        port.setMaximum(max);
        DoubleBoundedRangeModel model = PortModelFactory.createLinearModel(port);
        RotaryTextController knob = new RotaryTextController(model, 10);
        knob.setBorder(BorderFactory.createTitledBorder(label));
        knob.setTitle(label);
        return knob;
    }

    private RotaryTextController setupPortKnob(UnitInputPort port, double max, String label) {
        port.setMinimum(0.0);
        port.setMaximum(max);
        ExponentialRangeModel model = PortModelFactory.createExponentialModel(port);
        RotaryTextController knob = new RotaryTextController(model, 10);
        knob.setBorder(BorderFactory.createTitledBorder(label));
        knob.setTitle(label);
        return knob;
    }

    @Override
    public void start() {
        this.synth = JSyn.createSynthesizer();
        try {
            GrainFarm sampleGrainFarm;
            this.grainFarm = sampleGrainFarm = new GrainFarm();
            this.synth.add(this.grainFarm);
            this.grainFarm.allocate(32);
            this.lineOut = new LineOut();
            this.synth.add(this.lineOut);
            this.grainFarm.getOutput().connect(0, this.lineOut.input, 0);
            this.grainFarm.getOutput().connect(0, this.lineOut.input, 1);
            this.synth.start();
            this.setupGUI();
            this.lineOut.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            if (this.recorder != null) {
                this.recorder.stop();
                this.recorder.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.scope.stop();
        this.synth.stop();
    }
}

