/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.engine;

import com.jsyn.io.AudioFifo;
import junit.framework.TestCase;

public class TestFifo
extends TestCase {
    public void testBasic() {
        Thread watchdog = this.startWatchdog(600);
        AudioFifo fifo = new AudioFifo();
        fifo.setReadWaitEnabled(false);
        fifo.allocate(8);
        TestFifo.assertEquals((String)"start empty", (int)0, (int)fifo.available());
        TestFifo.assertEquals((String)"read back Nan when emopty", (Object)Double.NaN, (Object)fifo.read());
        fifo.write(1.0);
        TestFifo.assertEquals((String)"added one value", (int)1, (int)fifo.available());
        TestFifo.assertEquals((String)"read back same value", (Object)1.0, (Object)fifo.read());
        TestFifo.assertEquals((String)"back to empty", (int)0, (int)fifo.available());
        int i = 0;
        while (i < fifo.size()) {
            TestFifo.assertEquals((String)"adding data", (int)i, (int)fifo.available());
            fifo.write(100.0 + (double)i);
            ++i;
        }
        i = 0;
        while (i < fifo.size()) {
            TestFifo.assertEquals((String)"removing data", (int)(fifo.size() - i), (int)fifo.available());
            TestFifo.assertEquals((String)"reading back data", (Object)(100.0 + (double)i), (Object)fifo.read());
            ++i;
        }
        watchdog.interrupt();
    }

    public void testWrapping() {
        int chunk = 5;
        AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        double value = 1000.0;
        int i = 0;
        while (i < fifo.size() * 5) {
            value = this.checkFifoChunk(fifo, value, 5);
            ++i;
        }
    }

    private double checkFifoChunk(AudioFifo fifo, double value, int chunk) {
        int i = 0;
        while (i < chunk) {
            TestFifo.assertEquals((String)"adding data", (int)i, (int)fifo.available());
            fifo.write(value + (double)i);
            ++i;
        }
        i = 0;
        while (i < chunk) {
            TestFifo.assertEquals((String)"removing data", (int)(chunk - i), (int)fifo.available());
            TestFifo.assertEquals((String)"reading back data", (Object)(value + (double)i), (Object)fifo.read());
            ++i;
        }
        return value + (double)chunk;
    }

    public void testBadSize() {
        boolean caught = false;
        try {
            AudioFifo fifo = new AudioFifo();
            fifo.allocate(20);
            TestFifo.assertTrue((String)"should not get here", (boolean)false);
        }
        catch (IllegalArgumentException e) {
            caught = true;
        }
        TestFifo.assertTrue((String)"should have caught size exception", (boolean)caught);
    }

    public void testSingleReadWait() {
        int chunk = 5;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(false);
        fifo.setReadWaitEnabled(true);
        double value = 50.0;
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(200L);
                    int i = 0;
                    while (i < 5) {
                        fifo.write(50.0 + (double)i);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread watchdog = this.startWatchdog(500);
        int i = 0;
        while (i < 5) {
            TestFifo.assertEquals((String)"reading back data", (Object)(50.0 + (double)i), (Object)fifo.read());
            ++i;
        }
        watchdog.interrupt();
    }

    private Thread startWatchdog(final int msec) {
        Thread watchdog = new Thread(){

            @Override
            public void run() {
                try {
                    2.sleep(msec);
                    TestFifo.assertTrue((String)"test must still be waiting", (boolean)false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        watchdog.start();
        return watchdog;
    }

    public void testSingleWriteWait() {
        int chunk = 13;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(true);
        fifo.setReadWaitEnabled(true);
        double value = 50.0;
        Thread readThread = new Thread(){

            @Override
            public void run() {
                try {
                    3.sleep(200L);
                    int i = 0;
                    while (i < 13) {
                        double got = fifo.read();
                        TestFifo.assertEquals((String)"adding data", (Object)(50.0 + (double)i), (Object)got);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        readThread.start();
        Thread watchdog = this.startWatchdog(500);
        int i = 0;
        while (i < 13) {
            fifo.write(50.0 + (double)i);
            ++i;
        }
        watchdog.interrupt();
        try {
            readThread.join(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestFifo.assertEquals((String)"readThread should be done.", (boolean)false, (boolean)readThread.isAlive());
    }

    public void testBlockReadWait() {
        int chunk = 50;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(false);
        fifo.setReadWaitEnabled(true);
        double value = 300.0;
        double[] readBuffer = new double[50];
        new Thread(){

            @Override
            public void run() {
                int numWritten = 0;
                double[] writeBuffer = new double[4];
                try {
                    while (numWritten < 50) {
                        4.sleep(30L);
                        int i = 0;
                        while (i < writeBuffer.length) {
                            writeBuffer[i] = 300.0 + (double)numWritten;
                            ++numWritten;
                            ++i;
                        }
                        fifo.write(writeBuffer);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread watchdog = this.startWatchdog(600);
        fifo.read(readBuffer);
        int i = 0;
        while (i < 50) {
            TestFifo.assertEquals((String)"reading back data", (Object)(300.0 + (double)i), (Object)readBuffer[i]);
            ++i;
        }
        watchdog.interrupt();
    }

    public void testBlockReadAndWriteWaitStress() {
        int chunk = 10000000;
        final AudioFifo fifo = new AudioFifo();
        fifo.allocate(8);
        fifo.setWriteWaitEnabled(true);
        fifo.setReadWaitEnabled(true);
        double value = 50.0;
        new Thread(){

            @Override
            public void run() {
                try {
                    5.sleep(200L);
                    int i = 0;
                    while (i < 10000000) {
                        fifo.write(50.0 + (double)i);
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Thread watchdog = this.startWatchdog(10000);
        int i = 0;
        while (i < 10000000) {
            TestFifo.assertEquals((String)"reading back data", (Object)(50.0 + (double)i), (Object)fifo.read());
            ++i;
        }
        watchdog.interrupt();
    }
}

