/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class BarGraphElement
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    double value;
    double min = 0.0;
    double max = 1.0;
    int orientation = 1;
    double scalar = 1.0;

    public BarGraphElement(int orientation, double value, double min, double max) {
        this.orientation = orientation;
        this.value = value;
        this.min = min;
        this.max = max;
        this.updateScalar();
        this.setBackground(Color.darkGray);
        this.setForeground(Color.orange);
    }

    void updateScalar() {
        this.scalar = 1.0 / (this.max - this.min);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getScalar() {
        return this.scalar;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
        this.updateScalar();
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.updateScalar();
    }

    public void set(double newValue) {
        this.value = newValue;
        this.repaint();
    }

    public double get() {
        return this.value;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBar(g);
    }

    public void paintBar(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor(this.getForeground());
        if (this.orientation == 1) {
            int y = (int)((double)height * (this.value - this.min) * this.scalar);
            g.fillRect(0, height - y, width, y);
        } else {
            int x = (int)((double)width * (this.value - this.min) * this.scalar);
            g.fillRect(0, 0, x, height);
        }
    }
}

