/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.midi;

import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.midi.MidiEngine;
import com.syntona.model.midi.MidiInputModule;
import com.syntona.plugin.CopyConnectionHandler;
import com.syntona.plugin.InputDoubleJack;
import com.syntona.plugin.OutputDoubleJack;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;

public class AutoControlInModule
extends MidiInputModule {
    private static final String VALUE_TEXT = "value";
    private static final String ATTRIBUTE_CHANNEL = "channel";
    private static final String ATTRIBUTE_INDEX = "index";
    private static final String TAG_MATCH = "match";
    private InputDoubleJack mInput = new InputDoubleJack(this, "in");
    private OutputDoubleJack mValue;
    private MidiEngine.ControlChangeReceiver mReceiver;
    private int mActiveChannel = -1;
    private int mActiveIndex = -1;
    private boolean mAutoAssignArmed = true;

    public AutoControlInModule() {
        super("Receive MIDI Control Change messages if open.");
        this.mInput.setValue(1.0);
        this.mInput.setHelp("Used to set range for mapping the value.");
        this.mValue = new OutputDoubleJack(this, VALUE_TEXT);
        this.mValue.setConnectionHandler(new CopyConnectionHandler(this.mInput));
        this.mReceiver = new MidiEngine.ControlChangeReceiver(){

            @Override
            public void onControlChange(int channel, int index, int value) {
                boolean channelMatches;
                if (AutoControlInModule.this.mAutoAssignArmed) {
                    AutoControlInModule.this.mActiveChannel = channel;
                    AutoControlInModule.this.mActiveIndex = index;
                    AutoControlInModule.this.mAutoAssignArmed = false;
                    AutoControlInModule.this.mValue.setDefaultText(AutoControlInModule.this.generateDefaultText());
                }
                boolean indexMatches = AutoControlInModule.this.mActiveIndex < 0 || AutoControlInModule.this.mActiveIndex == index;
                boolean bl = channelMatches = AutoControlInModule.this.mActiveChannel < 0 || AutoControlInModule.this.mActiveChannel == channel;
                if (indexMatches && channelMatches) {
                    double range = AutoControlInModule.this.mInput.getMax() - AutoControlInModule.this.mInput.getMin();
                    double normalized = (double)value * 0.0078125;
                    double adjusted = normalized * range + AutoControlInModule.this.mInput.getMin();
                    AutoControlInModule.this.passDoubleMessage(adjusted, AutoControlInModule.this.mValue);
                }
            }
        };
        MidiEngine.getInstance().addControlChangeReceiver(this.mReceiver);
    }

    private String generateDefaultText() {
        return String.valueOf(this.mActiveChannel) + ":" + this.mActiveIndex;
    }

    @Override
    public void kick() {
    }

    @Override
    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        if (!this.mAutoAssignArmed) {
            saver.beginElement(TAG_MATCH);
            saver.addAttribute(ATTRIBUTE_INDEX, this.mActiveIndex);
            saver.addAttribute(ATTRIBUTE_CHANNEL, this.mActiveChannel);
            saver.endElement();
        }
    }

    @Override
    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException {
        Element element = XMLDOMLoader.getChildByTagName(moduleElement, TAG_MATCH);
        if (element != null) {
            this.mActiveIndex = (char)XMLDOMLoader.parseIntegerAttribute(element, ATTRIBUTE_INDEX, this.mActiveIndex);
            this.mActiveChannel = (char)XMLDOMLoader.parseIntegerAttribute(element, ATTRIBUTE_CHANNEL, this.mActiveChannel);
            this.mAutoAssignArmed = this.mActiveIndex < 0 || this.mActiveChannel < 0;
            this.mValue.setDefaultText(this.generateDefaultText());
        }
    }

    @Override
    public void reset() {
        this.mActiveChannel = -1;
        this.mActiveIndex = -1;
        this.mAutoAssignArmed = true;
        this.mValue.setDefaultText(VALUE_TEXT);
    }

    @Override
    public boolean isResettable() {
        return true;
    }
}

