/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.EnvelopeDAHDSR;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.TestUnitGate;

public class TestEnvelopeDAHDSR
extends TestUnitGate {
    double delayTime;
    double attackTime;
    double holdTime;
    double decayTime;
    double sustainLevel;
    double releaseTime;

    protected void setUp() throws Exception {
        super.setUp();
        this.synthesisEngine = new SynthesisEngine();
        this.synthesisEngine.setRealTime(false);
        this.delayTime = 0.1;
        this.attackTime = 0.2;
        this.holdTime = 0.3;
        this.decayTime = 0.4;
        this.sustainLevel = 0.5;
        this.releaseTime = 0.6;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.synthesisEngine.stop();
    }

    public void testStages() throws InterruptedException {
        EnvelopeDAHDSR ramp = this.checkToSustain();
        this.sustainLevel = 0.7;
        ramp.sustain.set(this.sustainLevel);
        this.time += 0.01;
        this.synthesisEngine.sleepUntil(this.time);
        TestEnvelopeDAHDSR.assertEquals((String)"sustain moving delaying", (double)this.sustainLevel, (double)ramp.output.getValue(), (double)0.01);
        ramp.input.set(0.0);
        this.synthesisEngine.sleepUntil(this.time + this.releaseTime * 0.1);
        double releaseValue = ramp.output.getValue();
        TestEnvelopeDAHDSR.assertEquals((String)"partway down release", (double)(this.sustainLevel * 0.36), (double)releaseValue, (double)0.01);
    }

    private EnvelopeDAHDSR checkToSustain() throws InterruptedException {
        EnvelopeDAHDSR ramp = new EnvelopeDAHDSR();
        this.synthesisEngine.add(ramp);
        ramp.delay.set(this.delayTime);
        ramp.attack.set(this.attackTime);
        ramp.hold.set(this.holdTime);
        ramp.decay.set(this.decayTime);
        ramp.sustain.set(this.sustainLevel);
        ramp.release.set(this.releaseTime);
        this.synthesisEngine.start();
        ramp.start();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 2.0 * this.delayTime);
        TestEnvelopeDAHDSR.assertEquals((String)"still idling", (Object)0.0, (Object)ramp.output.getValue());
        ramp.input.set(1.0);
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + this.delayTime * 0.9);
        TestEnvelopeDAHDSR.assertEquals((String)"still delaying", (double)0.0, (double)ramp.output.getValue(), (double)0.01);
        this.synthesisEngine.sleepUntil(this.time + this.delayTime + this.attackTime * 0.5);
        TestEnvelopeDAHDSR.assertEquals((String)"half attack", (double)0.5, (double)ramp.output.getValue(), (double)0.01);
        this.synthesisEngine.sleepUntil(this.time + this.delayTime + this.attackTime + this.holdTime * 0.1);
        TestEnvelopeDAHDSR.assertEquals((String)"holding", (double)1.0, (double)ramp.output.getValue(), (double)0.01);
        this.synthesisEngine.sleepUntil(this.time + this.delayTime + this.attackTime + this.holdTime * 0.9);
        TestEnvelopeDAHDSR.assertEquals((String)"still holding", (double)1.0, (double)ramp.output.getValue(), (double)0.01);
        this.synthesisEngine.sleepUntil(this.time + this.delayTime + this.attackTime + this.holdTime + this.decayTime);
        this.time = this.synthesisEngine.getCurrentTime();
        TestEnvelopeDAHDSR.assertEquals((String)"at sustain", (double)this.sustainLevel, (double)ramp.output.getValue(), (double)0.01);
        return ramp;
    }

    public void testRetrigger() throws InterruptedException {
        EnvelopeDAHDSR ramp = this.checkToSustain();
        ramp.input.set(0.0);
        this.synthesisEngine.sleepUntil(this.time + this.releaseTime * 0.1);
        double releaseValue = ramp.output.getValue();
        TestEnvelopeDAHDSR.assertEquals((String)"partway down release", (double)(this.sustainLevel * 0.36), (double)releaseValue, (double)0.01);
        this.time = this.synthesisEngine.getCurrentTime();
        ramp.input.set(1.0);
        this.synthesisEngine.sleepUntil(this.time + this.delayTime * 0.9);
        TestEnvelopeDAHDSR.assertEquals((String)"still delaying", (double)releaseValue, (double)ramp.output.getValue(), (double)0.01);
        this.synthesisEngine.sleepUntil(this.time + this.delayTime + this.attackTime * 0.5);
        TestEnvelopeDAHDSR.assertEquals((String)"half attack", (double)(releaseValue + 0.5), (double)ramp.output.getValue(), (double)0.01);
    }

    public void testHang() throws InterruptedException {
        this.delayTime = 0.0;
        this.attackTime = 0.0;
        this.holdTime = 0.0;
        this.decayTime = 0.0;
        this.sustainLevel = 0.3;
        this.releaseTime = 3.0;
        EnvelopeDAHDSR ramp = new EnvelopeDAHDSR();
        this.synthesisEngine.add(ramp);
        ramp.delay.set(this.delayTime);
        ramp.attack.set(this.attackTime);
        ramp.hold.set(this.holdTime);
        ramp.decay.set(this.decayTime);
        ramp.sustain.set(this.sustainLevel);
        ramp.release.set(this.releaseTime);
        this.synthesisEngine.start();
        ramp.start();
        ramp.input.set(1.0);
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.01);
        TestEnvelopeDAHDSR.assertEquals((String)"should jump to sustain level", (Object)this.sustainLevel, (Object)ramp.output.getValue());
        ramp.input.set(0.0);
        this.synthesisEngine.sleepUntil(this.time + 1.0);
        double releaseValue = ramp.output.getValue();
        TestEnvelopeDAHDSR.assertTrue((String)"partway down release", (this.sustainLevel > releaseValue ? 1 : 0) != 0);
        this.holdTime = 0.5;
        ramp.hold.set(this.holdTime);
        this.decayTime = 0.5;
        ramp.decay.set(this.decayTime);
        this.time = this.synthesisEngine.getCurrentTime();
        ramp.input.set(1.0);
        this.synthesisEngine.sleepUntil(this.time + this.holdTime * 0.1);
        TestEnvelopeDAHDSR.assertEquals((String)"should jump to hold", (double)1.0, (double)ramp.output.getValue(), (double)0.01);
    }

    public void testNegative() throws InterruptedException {
        this.delayTime = -0.1;
        this.attackTime = -0.2;
        this.holdTime = -0.3;
        this.decayTime = -0.4;
        this.sustainLevel = 0.3;
        this.releaseTime = -0.5;
        EnvelopeDAHDSR ramp = new EnvelopeDAHDSR();
        this.synthesisEngine.add(ramp);
        ramp.delay.set(this.delayTime);
        ramp.attack.set(this.attackTime);
        ramp.hold.set(this.holdTime);
        ramp.decay.set(this.decayTime);
        ramp.sustain.set(this.sustainLevel);
        ramp.release.set(this.releaseTime);
        this.synthesisEngine.start();
        ramp.start();
        ramp.input.set(1.0);
        this.time = this.synthesisEngine.getCurrentTime();
        this.time += 0.1;
        this.synthesisEngine.sleepUntil(this.time + 0.01);
        TestEnvelopeDAHDSR.assertEquals((String)"should jump to sustain level", (Object)this.sustainLevel, (Object)ramp.output.getValue());
        this.sustainLevel = -0.4;
        ramp.sustain.set(-0.4);
        this.time += 0.1;
        this.synthesisEngine.sleepUntil(this.time);
        TestEnvelopeDAHDSR.assertEquals((String)"sustain should clip at zero", (Object)this.sustainLevel, (Object)ramp.output.getValue());
        this.sustainLevel = 0.4;
        ramp.sustain.set(0.4);
        this.time += 0.1;
        this.synthesisEngine.sleepUntil(this.time);
        TestEnvelopeDAHDSR.assertEquals((String)"sustain should come back", (Object)this.sustainLevel, (Object)ramp.output.getValue());
        ramp.input.set(0.0);
        this.time += 0.1;
        this.synthesisEngine.sleepUntil(this.time);
        double releaseValue = ramp.output.getValue();
        TestEnvelopeDAHDSR.assertEquals((String)"release quickly", (Object)0.0, (Object)releaseValue);
    }

    public void testOnOff() throws InterruptedException {
        EnvelopeDAHDSR ramp = new EnvelopeDAHDSR();
        this.synthesisEngine.add(ramp);
        ramp.delay.set(0.0);
        ramp.attack.set(0.1);
        ramp.hold.set(0.0);
        ramp.decay.set(0.0);
        ramp.sustain.set(0.9);
        ramp.release.set(0.1);
        this.synthesisEngine.start();
        ramp.start();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.2);
        TestEnvelopeDAHDSR.assertEquals((String)"still idling", (Object)0.0, (Object)ramp.output.getValue());
        ramp.input.on();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.2);
        TestEnvelopeDAHDSR.assertEquals((String)"at sustain", (double)0.9, (double)ramp.output.getValue(), (double)0.01);
        ramp.input.off();
        this.time = this.synthesisEngine.getCurrentTime();
        this.synthesisEngine.sleepUntil(this.time + 0.2);
        TestEnvelopeDAHDSR.assertEquals((String)"after release", (double)0.0, (double)ramp.output.getValue(), (double)0.01);
    }

    public void testAutoDisable() throws InterruptedException {
        LinearRamp ramp = new LinearRamp();
        this.synthesisEngine.add(ramp);
        EnvelopeDAHDSR envelope = new EnvelopeDAHDSR();
        this.synthesisEngine.add(envelope);
        envelope.attack.set(0.1);
        envelope.decay.set(0.1);
        envelope.release.set(0.1);
        envelope.sustain.set(0.1);
        ramp.output.connect(envelope.amplitude);
        this.checkAutoDisable(ramp, envelope);
    }

    public void testAutoDisableCircuit() throws InterruptedException {
        GatedRampCircuit circuit = new GatedRampCircuit();
        this.synthesisEngine.add(circuit);
        this.checkAutoDisable(circuit.ramp, circuit.envelope);
    }

    public void checkReleaseTiming(double releaseTime, double tolerance) throws InterruptedException {
        this.delayTime = 0.0;
        this.attackTime = 0.2;
        this.holdTime = 0.0;
        this.decayTime = 10.0;
        this.sustainLevel = 1.0;
        EnvelopeDAHDSR ramp = new EnvelopeDAHDSR();
        this.synthesisEngine.add(ramp);
        ramp.delay.set(this.delayTime);
        ramp.attack.set(this.attackTime);
        ramp.hold.set(this.holdTime);
        ramp.decay.set(this.decayTime);
        ramp.sustain.set(this.sustainLevel);
        ramp.release.set(releaseTime);
        this.synthesisEngine.start();
        ramp.start();
        ramp.input.set(1.0);
        this.time = this.synthesisEngine.getCurrentTime();
        this.time += this.attackTime * 2.0;
        this.synthesisEngine.sleepUntil(this.time);
        TestEnvelopeDAHDSR.assertEquals((String)"should be at to sustain level", (Object)this.sustainLevel, (Object)ramp.output.getValue());
        ramp.input.set(0.0);
        double db90 = 20.0 * Math.log(3.0517578125E-5) / Math.log(10.0);
        System.out.println("JSyns DB90 is actually " + db90);
        int numSteps = 10;
        int i = 0;
        while (i < 10) {
            this.time += releaseTime / (double)numSteps;
            this.synthesisEngine.sleepUntil(this.time);
            double expectedDB = db90 * (double)(i + 1) / (double)numSteps;
            double expectedAmplitude = this.sustainLevel * Math.pow(10.0, expectedDB / 20.0);
            double releaseValue = ramp.output.getValue();
            TestEnvelopeDAHDSR.assertEquals((String)("release " + i + " at"), (double)expectedAmplitude, (double)releaseValue, (double)tolerance);
            ++i;
        }
        this.time += releaseTime / (double)numSteps;
        this.synthesisEngine.sleepUntil(this.time);
        double releaseValue = ramp.output.getValue();
        TestEnvelopeDAHDSR.assertEquals((String)"env after release time should go to zero", (double)0.0, (double)releaseValue, (double)1.0E-4);
    }

    public void testReleaseTiming() throws InterruptedException {
        this.checkReleaseTiming(0.1, 0.004);
        this.checkReleaseTiming(1.0, 0.002);
        this.checkReleaseTiming(2.5, 0.001);
        this.checkReleaseTiming(10.0, 0.001);
    }

    class GatedRampCircuit
    extends Circuit {
        LinearRamp ramp = new LinearRamp();
        EnvelopeDAHDSR envelope;

        GatedRampCircuit() {
            this.add(this.ramp);
            this.envelope = new EnvelopeDAHDSR();
            this.add(this.envelope);
            this.envelope.attack.set(0.1);
            this.envelope.decay.set(0.1);
            this.envelope.release.set(0.1);
            this.envelope.sustain.set(0.1);
            this.envelope.setupAutoDisable(this);
            this.ramp.output.connect(this.envelope.amplitude);
        }
    }
}

