/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.EnablingGate;
import com.jsyn.unitgen.LinearRamp;
import junit.framework.TestCase;

public class TestEnable
extends TestCase {
    SynthesisEngine synthesisEngine;

    protected void setUp() throws Exception {
        super.setUp();
        this.synthesisEngine = new SynthesisEngine();
        this.synthesisEngine.setRealTime(false);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.synthesisEngine.stop();
    }

    public void testEnablingGate() throws InterruptedException {
        LinearRamp ramp = new LinearRamp();
        this.synthesisEngine.add(ramp);
        EnablingGate enabler = new EnablingGate();
        this.synthesisEngine.add(enabler);
        Add adder = new Add();
        this.synthesisEngine.add(adder);
        ramp.output.connect(enabler.input);
        enabler.output.connect(adder.inputA);
        ramp.current.set(0.0);
        ramp.input.set(1.0);
        ramp.time.set(1.0);
        enabler.gate.set(1.0);
        this.synthesisEngine.start();
        double startTime = this.synthesisEngine.getCurrentTime();
        adder.start();
        this.synthesisEngine.sleepUntil(startTime + 0.1);
        double tolerance = 0.002;
        TestEnable.assertEquals((String)"ramp going up", (double)0.1, (double)ramp.output.getValue(), (double)tolerance);
        TestEnable.assertEquals((String)"enabler going up", (double)0.1, (double)enabler.output.getValue(), (double)tolerance);
        TestEnable.assertEquals((String)"adder going up", (double)0.1, (double)adder.output.getValue(), (double)tolerance);
        this.synthesisEngine.sleepUntil(startTime + 0.2);
        TestEnable.assertEquals((String)"start enabled", (double)0.2, (double)adder.output.getValue(), (double)tolerance);
        enabler.gate.set(0.0);
        this.synthesisEngine.sleepUntil(startTime + 0.3);
        TestEnable.assertEquals((String)"should not be pulled", (double)0.2, (double)ramp.output.getValue(), (double)tolerance);
        TestEnable.assertEquals((String)"should be disabled", (boolean)false, (boolean)enabler.isEnabled());
        TestEnable.assertEquals((String)"should be zero", (double)0.0, (double)enabler.output.getValue(), (double)tolerance);
        TestEnable.assertEquals((String)"zero", (double)0.0, (double)adder.output.getValue(), (double)tolerance);
    }
}

